/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.util.ExtRunnable;
import com.facebook.util.exceptions.ExceptionHandler;
import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicReference;

class ShortCircuitRunnable<E extends Exception>
implements Function<ExtRunnable<E>, Runnable> {
    private final AtomicReference<E> exception;
    private final ExceptionHandler<E> exceptionHandler;

    ShortCircuitRunnable(AtomicReference<E> exception, ExceptionHandler<E> exceptionHandler) {
        this.exception = exception;
        this.exceptionHandler = exceptionHandler;
    }

    public Runnable apply(ExtRunnable<E> task) {
        return () -> {
            try {
                if (this.exception.get() == null) {
                    task.run();
                }
            }
            catch (Exception e) {
                this.exception.compareAndSet(null, this.exceptionHandler.handle(e));
            }
        };
    }
}

