/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class TaskGroup {
    private final ExecutorService defaultExecutor;
    private final Collection<Pair<ExecutorService, Runnable>> taskPairs = new ArrayList<Pair<ExecutorService, Runnable>>();

    public TaskGroup(ExecutorService defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public TaskGroup() {
        this(null);
    }

    public synchronized void register(ExecutorService executorService, Runnable task) {
        this.taskPairs.add((Pair<ExecutorService, Runnable>)new Pair((Object)executorService, (Object)task));
    }

    public void register(Runnable task) {
        if (this.defaultExecutor == null) {
            throw new IllegalStateException("No default executor specified");
        }
        this.register(this.defaultExecutor, task);
    }

    public synchronized FinishLatch execute() {
        final CountDownLatch finishLatch = new CountDownLatch(this.taskPairs.size());
        for (final Pair<ExecutorService, Runnable> taskPair : this.taskPairs) {
            ((ExecutorService)taskPair.getFirst()).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Runnable)taskPair.getSecond()).run();
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }
            });
        }
        return new FinishLatch(finishLatch);
    }

    public static class FinishLatch {
        private final CountDownLatch finishLatch;

        private FinishLatch(CountDownLatch finishLatch) {
            this.finishLatch = finishLatch;
        }

        public boolean await(long waitTime, TimeUnit waitTimeUnit) throws InterruptedException {
            return this.finishLatch.await(waitTime, waitTimeUnit);
        }

        public void await() throws InterruptedException {
            this.finishLatch.await();
        }
    }
}

