/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.TrackedRunnable;
import com.facebook.concurrency.UnstoppableExecutorServiceCore;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UnstoppableExecutorService
implements ExecutorService {
    private final UnstoppableExecutorServiceCore executorCore;
    private final ExecutorService executor;

    public UnstoppableExecutorService(ExecutorService executor) {
        this.executor = executor;
        this.executorCore = new UnstoppableExecutorServiceCore();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.executorCore.registerTask(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        TrackedRunnable trackedTask = this.executorCore.registerTask(task);
        return this.executorCore.trackFuture(this.executor.submit(trackedTask, result), trackedTask);
    }

    @Override
    public Future<?> submit(Runnable task) {
        TrackedRunnable trackedTask = this.executorCore.registerTask(task);
        return this.executorCore.trackFuture(this.executor.submit(trackedTask), trackedTask);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return this.executorCore.trackFutureList(this.executor.invokeAll(trackedTaskList), trackedTaskList);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return this.executorCore.trackFutureList(this.executor.invokeAll(trackedTaskList, timeout, unit), trackedTaskList);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return (T)this.executor.invokeAny(trackedTaskList);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return (T)this.executor.invokeAny(trackedTaskList, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(this.executorCore.registerTask(command));
    }

    @Override
    public void shutdown() {
        this.executorCore.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorCore.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorCore.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorCore.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorCore.awaitTermination(timeout, unit);
    }
}

