/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.collections.ListMapper;
import com.facebook.collectionsbase.Mapper;
import com.facebook.concurrency.Completable;
import com.facebook.concurrency.TrackedCallable;
import com.facebook.concurrency.TrackedRunnable;
import com.facebook.concurrency.WrappedFuture;
import com.facebook.concurrency.WrappedScheduledFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTimeUtils;

class UnstoppableExecutorServiceCore {
    private final AtomicInteger remaining = new AtomicInteger(0);
    private volatile boolean isShutdown = false;

    UnstoppableExecutorServiceCore() {
    }

    public List<Runnable> registerRunnableList(List<Runnable> taskList) {
        if (this.isShutdown) {
            throw new RejectedExecutionException("executor shutdown already");
        }
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (Runnable task : taskList) {
            result.add(new TrackedRunnableImpl(task));
        }
        return result;
    }

    public <V> List<TrackedCallable<V>> registerCallableList(Collection<? extends Callable<V>> taskList) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("executor shutdown already");
        }
        ArrayList<TrackedCallable<V>> result = new ArrayList<TrackedCallable<V>>();
        for (Callable<V> task : taskList) {
            result.add(new TrackedCallableImpl(task));
        }
        return result;
    }

    public TrackedRunnable registerTask(Runnable task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("executor shutdown already");
        }
        return new TrackedRunnableImpl(task);
    }

    public <V> TrackedCallable<V> registerTask(Callable<V> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("executor shutdown already");
        }
        return new TrackedCallableImpl(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRemaining() {
        if (this.remaining.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.remaining;
            synchronized (atomicInteger) {
                this.remaining.notifyAll();
            }
        }
    }

    public synchronized void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public boolean isTerminated() {
        assert (this.remaining.get() >= 0);
        return this.remaining.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown) {
            return false;
        }
        long start = DateTimeUtils.currentTimeMillis();
        AtomicInteger atomicInteger = this.remaining;
        synchronized (atomicInteger) {
            while (this.remaining.get() > 0) {
                this.remaining.wait(50L);
                long elapsedMillis = DateTimeUtils.currentTimeMillis() - start;
                if (elapsedMillis <= unit.toMillis(timeout)) continue;
                return false;
            }
        }
        return true;
    }

    public <V> List<Future<V>> trackFutureList(List<Future<V>> futureList, List<? extends Completable> completableList) {
        return ListMapper.map(futureList, new FutureMapper(completableList));
    }

    public <V> Future<V> trackFuture(Future<V> future, Completable task) {
        return new TrackedFuture(future, task);
    }

    public <V> ScheduledFuture<V> trackScheduledFuture(ScheduledFuture<V> future, Completable task) {
        return new TrackedScheduledFuture(future, task);
    }

    private class FutureMapper<V>
    implements Mapper<Future<V>, Future<V>> {
        private final List<? extends Completable> completableList;
        private int index = 0;

        private FutureMapper(List<? extends Completable> completableList) {
            this.completableList = completableList;
        }

        public Future<V> map(Future<V> input) {
            TrackedFuture trackedFuture = new TrackedFuture(input, this.completableList.get(this.index));
            ++this.index;
            return trackedFuture;
        }
    }

    private class TrackedScheduledFuture<V>
    extends WrappedScheduledFuture<V> {
        private final Completable task;

        private TrackedScheduledFuture(ScheduledFuture<V> delegate, Completable task) {
            super(delegate);
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.task.complete();
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private class TrackedFuture<V>
    extends WrappedFuture<V> {
        private final Completable task;

        private TrackedFuture(Future<V> delegate, Completable task) {
            super(delegate);
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.task.complete();
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private class TrackedCallableImpl<V>
    implements TrackedCallable<V> {
        private final Callable<V> delegate;
        private final AtomicBoolean hasCompleted = new AtomicBoolean(false);

        private TrackedCallableImpl(Callable<V> delegate) {
            this.delegate = delegate;
            UnstoppableExecutorServiceCore.this.remaining.incrementAndGet();
        }

        @Override
        public V call() throws Exception {
            try {
                V v = this.delegate.call();
                return v;
            }
            finally {
                this.complete();
            }
        }

        @Override
        public void complete() {
            if (this.hasCompleted.compareAndSet(false, true)) {
                UnstoppableExecutorServiceCore.this.decrementRemaining();
            }
        }
    }

    private class TrackedRunnableImpl
    implements TrackedRunnable {
        private final Runnable delegate;
        private final AtomicBoolean hasCompleted = new AtomicBoolean(false);

        private TrackedRunnableImpl(Runnable delegate) {
            this.delegate = delegate;
            UnstoppableExecutorServiceCore.this.remaining.incrementAndGet();
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            finally {
                this.complete();
            }
        }

        @Override
        public void complete() {
            if (this.hasCompleted.compareAndSet(false, true)) {
                UnstoppableExecutorServiceCore.this.decrementRemaining();
            }
        }
    }
}

