/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.TrackedCallable;
import com.facebook.concurrency.TrackedRunnable;
import com.facebook.concurrency.UnstoppableExecutorServiceCore;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnstoppableScheduledExecutorService
implements ScheduledExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(UnstoppableScheduledExecutorService.class);
    private final UnstoppableExecutorServiceCore executorCore;
    private final ScheduledExecutorService executor;
    private final Map<ScheduledFuture<?>, ScheduledFuture<?>> outstandingScheduledTasks = Collections.synchronizedMap(new IdentityHashMap());
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    public UnstoppableScheduledExecutorService(ScheduledExecutorService executor) {
        this.executor = executor;
        this.executorCore = new UnstoppableExecutorServiceCore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledFuture<?> internalScheduleRunnable(Runnable runnable, RunnableCallback callback) {
        this.shutdownLock.readLock().lock();
        try {
            TrackedRunnable trackedTask = this.executorCore.registerTask(runnable);
            BookkeepingTask task = new BookkeepingTask(trackedTask);
            ScheduledFuture<?> scheduledFuture = this.executorCore.trackScheduledFuture(callback.submit(task), trackedTask);
            task.openGate(scheduledFuture);
            ScheduledFuture<?> scheduledFuture2 = scheduledFuture;
            return scheduledFuture2;
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> ScheduledFuture<V> internalScheduleCallable(Callable<V> callable, CallableCallback<V> callback) {
        this.shutdownLock.readLock().lock();
        try {
            TrackedCallable<V> trackedTask = this.executorCore.registerTask(callable);
            BookkeepingTask<V> task = new BookkeepingTask<V>(trackedTask);
            ScheduledFuture<V> scheduledFuture = this.executorCore.trackScheduledFuture(callback.submit(task), trackedTask);
            task.openGate(scheduledFuture);
            ScheduledFuture<V> scheduledFuture2 = scheduledFuture;
            return scheduledFuture2;
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    private void cancelPendingTasks() {
        for (Map.Entry<ScheduledFuture<?>, ScheduledFuture<?>> entry : this.outstandingScheduledTasks.entrySet()) {
            entry.getValue().cancel(false);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, final long delay, final TimeUnit unit) {
        return this.internalScheduleRunnable(command, new RunnableCallback(){

            @Override
            public ScheduledFuture<?> submit(Runnable task) {
                return UnstoppableScheduledExecutorService.this.executor.schedule(task, delay, unit);
            }
        });
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, final long delay, final TimeUnit unit) {
        return this.internalScheduleCallable(callable, new CallableCallback<V>(){

            @Override
            public ScheduledFuture<V> submit(Callable<V> task) {
                return UnstoppableScheduledExecutorService.this.executor.schedule(task, delay, unit);
            }
        });
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, final long initialDelay, final long period, final TimeUnit unit) {
        return this.internalScheduleRunnable(command, new RunnableCallback(){

            @Override
            public ScheduledFuture<?> submit(Runnable task) {
                return UnstoppableScheduledExecutorService.this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            }
        });
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(final Runnable command, final long initialDelay, final long delay, final TimeUnit unit) {
        return this.internalScheduleRunnable(command, new RunnableCallback(){

            @Override
            public ScheduledFuture<?> submit(Runnable task) {
                return UnstoppableScheduledExecutorService.this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            }
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        TrackedCallable<T> trackedTask = this.executorCore.registerTask(task);
        return this.executorCore.trackFuture(this.executor.submit(trackedTask), trackedTask);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        TrackedRunnable trackedTask = this.executorCore.registerTask(task);
        return this.executorCore.trackFuture(this.executor.submit(trackedTask, result), trackedTask);
    }

    @Override
    public Future<?> submit(Runnable task) {
        TrackedRunnable trackedTask = this.executorCore.registerTask(task);
        return this.executorCore.trackFuture(this.executor.submit(trackedTask), trackedTask);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return this.executorCore.trackFutureList(this.executor.invokeAll(trackedTaskList), trackedTaskList);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return this.executorCore.trackFutureList(this.executor.invokeAll(trackedTaskList, timeout, unit), trackedTaskList);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return (T)this.executor.invokeAny(trackedTaskList);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List trackedTaskList = this.executorCore.registerCallableList(tasks);
        return (T)this.executor.invokeAny(trackedTaskList, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(this.executorCore.registerTask(command));
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdownLock.writeLock().lock();
        try {
            List<Runnable> runnableList = this.executorCore.shutdownNow();
            this.cancelPendingTasks();
            List<Runnable> list = runnableList;
            return list;
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.executorCore.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorCore.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorCore.awaitTermination(timeout, unit);
    }

    private static interface CallableCallback<V> {
        public ScheduledFuture<V> submit(Callable<V> var1);
    }

    private static interface RunnableCallback<V> {
        public ScheduledFuture<?> submit(Runnable var1);
    }

    private class BookkeepingTask<V>
    implements Runnable,
    Callable<V> {
        private final CountDownLatch gate = new CountDownLatch(1);
        private final Callable<V> callable;
        private final Runnable runnable;
        private ScheduledFuture<?> future;

        private BookkeepingTask(Callable<V> callable) {
            this.runnable = null;
            this.callable = callable;
        }

        private BookkeepingTask(Runnable runnable) {
            this.runnable = runnable;
            this.callable = null;
        }

        public void openGate(ScheduledFuture<V> future) {
            this.future = future;
            UnstoppableScheduledExecutorService.this.outstandingScheduledTasks.put(future, future);
            this.gate.countDown();
        }

        private V internalRun() throws Exception {
            try {
                this.gate.await();
                if (this.runnable != null) {
                    this.runnable.run();
                    V v = null;
                    return v;
                }
                V v = this.callable.call();
                return v;
            }
            catch (InterruptedException e) {
                LOG.info("interrupted, skipping execution of task");
                Thread.currentThread().interrupt();
                V v = null;
                return v;
            }
            finally {
                this.cleanup();
            }
        }

        private void cleanup() {
            UnstoppableScheduledExecutorService.this.shutdownLock.readLock().lock();
            try {
                UnstoppableScheduledExecutorService.this.outstandingScheduledTasks.remove(this.future);
            }
            finally {
                UnstoppableScheduledExecutorService.this.shutdownLock.readLock().unlock();
            }
        }

        @Override
        public void run() {
            try {
                this.internalRun();
            }
            catch (Exception e) {
                LOG.error("exception during execution", (Throwable)e);
            }
        }

        @Override
        public V call() throws Exception {
            return this.internalRun();
        }
    }
}

