/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency.linearization;

import com.facebook.concurrency.linearization.ConcurrentPoint;
import com.facebook.concurrency.linearization.LinearizationPoint;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Linearizer {
    private static final Logger LOG = LoggerImpl.getLogger(Linearizer.class);
    private static final long COMPLETE_WAIT_TIME_SECONDS = 300L;
    private final AtomicReference<AtomicInteger> pointCountRef = new AtomicReference<AtomicInteger>(new AtomicInteger(0));
    private final AtomicReference<LinearizationPoint> lastLinearizationPointRef = new AtomicReference();

    public synchronized ConcurrentPoint createConcurrentPoint() {
        return new ConcurrentPointImpl(this.pointCountRef.get(), this.lastLinearizationPointRef.get());
    }

    public synchronized LinearizationPoint createLinearizationPoint() {
        AtomicInteger nextPointCount = new AtomicInteger();
        AtomicInteger previousPointCount = this.pointCountRef.getAndSet(nextPointCount);
        LinearizationPointImpl linearizationPoint = new LinearizationPointImpl(previousPointCount, nextPointCount);
        this.lastLinearizationPointRef.set(linearizationPoint);
        return linearizationPoint;
    }

    private static class LinearizationPointImpl
    implements LinearizationPoint {
        private final CountDownLatch startSignal = new CountDownLatch(1);
        private final CountDownLatch completeSignal = new CountDownLatch(1);
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private final AtomicInteger previousPointCount;
        private final AtomicInteger nextPointCount;

        private LinearizationPointImpl(AtomicInteger previousPointCount, AtomicInteger nextPointCount) {
            nextPointCount.incrementAndGet();
            this.nextPointCount = nextPointCount;
            this.previousPointCount = previousPointCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilPreviousPointsComplete() {
            try {
                AtomicInteger atomicInteger = this.previousPointCount;
                synchronized (atomicInteger) {
                    while (this.previousPointCount.get() > 0) {
                        this.previousPointCount.wait(5000L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted waiting for ConcurrentPoints", e);
            }
        }

        @Override
        public void start() {
            this.waitUntilPreviousPointsComplete();
            this.startSignal.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            if (this.completed.compareAndSet(false, true)) {
                int result = this.nextPointCount.decrementAndGet();
                if (result == 0) {
                    AtomicInteger atomicInteger = this.nextPointCount;
                    synchronized (atomicInteger) {
                        this.nextPointCount.notifyAll();
                    }
                }
                this.completeSignal.countDown();
            }
        }

        @Override
        public void waitForStart() throws InterruptedException {
            while (!this.startSignal.await(300L, TimeUnit.SECONDS)) {
                LOG.info("waited %d seconds for LinearizationPoint.start, will wait some more", new Object[]{300L});
            }
        }

        @Override
        public boolean waitForStart(long timeout, TimeUnit unit) throws InterruptedException {
            return this.startSignal.await(timeout, unit);
        }

        @Override
        public void waitForCompletion() throws InterruptedException {
            while (!this.completeSignal.await(300L, TimeUnit.SECONDS)) {
                LOG.info("waited %d seconds for LinearizationPoint.complete, will wait some more", new Object[]{300L});
            }
        }

        @Override
        public boolean waitForCompletion(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completeSignal.await(timeout, unit);
        }
    }

    private static class ConcurrentPointImpl
    implements ConcurrentPoint {
        private final AtomicInteger pointCount;
        private final LinearizationPoint previousLinearizationPoint;
        private final AtomicBoolean completed = new AtomicBoolean(false);

        private ConcurrentPointImpl(AtomicInteger pointCount, LinearizationPoint previousLinearizationPoint) {
            pointCount.incrementAndGet();
            this.previousLinearizationPoint = previousLinearizationPoint;
            this.pointCount = pointCount;
        }

        @Override
        public void start() {
            try {
                if (this.previousLinearizationPoint != null) {
                    this.previousLinearizationPoint.waitForCompletion();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted waiting for previous LinearizationPoint to complete");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            int result;
            if (this.completed.compareAndSet(false, true) && (result = this.pointCount.decrementAndGet()) == 0) {
                AtomicInteger atomicInteger = this.pointCount;
                synchronized (atomicInteger) {
                    this.pointCount.notifyAll();
                }
            }
        }
    }
}

