/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.concurrent;

import com.facebook.stats.concurrent.Snapshot;
import com.facebook.stats.concurrent.Stat;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class RateStat
implements Stat {
    private static final int WINDOW_COUNT = 3601;
    private final String key;
    private final Clock clock;
    private final long created;
    private final AtomicLong lastRoll;
    private final long[] rollingWindows = new long[3601];
    private final LongAdder total = new LongAdder();
    private int currentOffset;

    public RateStat(String key) {
        this(key, Clock.systemUTC());
    }

    public RateStat(String key, Clock clock) {
        this.key = key;
        this.clock = clock;
        this.created = clock.millis() / 1000L;
        this.lastRoll = new AtomicLong(this.created);
    }

    @Override
    public void update(long value) {
        this.rollWindows();
        this.total.add(value);
    }

    public String toString() {
        return "RateStat{" + this.key + '}';
    }

    public Snapshot getRate() {
        return this.getSum().rate(this.clock.millis() / 1000L - this.created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSum() {
        this.rollWindows();
        long[] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            long total = this.total.sum();
            int offset = this.currentOffset + 3601;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Snapshot("sum", total, total - this.rollingWindows[(offset - 3600) % 3601], total - this.rollingWindows[(offset - 600) % 3601], total - this.rollingWindows[(offset - 60) % 3601]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rollWindows() {
        long lastRoll;
        long now = this.clock.millis() / 1000L;
        int elapsed = (int)(now - (lastRoll = this.lastRoll.get()));
        if (elapsed < 1 || !this.lastRoll.compareAndSet(lastRoll, now)) return;
        long total = this.total.sum();
        if (elapsed > 3601) {
            elapsed = 3601;
        }
        long[] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            do {
                --elapsed;
                this.rollingWindows[this.currentOffset] = total;
                if (this.currentOffset >= 3600) {
                    this.currentOffset = 0;
                    continue;
                }
                ++this.currentOffset;
            } while (elapsed > 0);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            return;
        }
    }
}

