/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.concurrent;

import java.util.Objects;

public class Snapshot {
    private final String type;
    private final long allTime;
    private final long hour;
    private final long tenMinute;
    private final long minute;

    public Snapshot(String type, long allTime, long hour, long tenMinute, long minute) {
        this.type = type;
        this.allTime = allTime;
        this.hour = hour;
        this.tenMinute = tenMinute;
        this.minute = minute;
    }

    public String getType() {
        return this.type;
    }

    public long getAllTime() {
        return this.allTime;
    }

    public long getHour() {
        return this.hour;
    }

    public long getTenMinute() {
        return this.tenMinute;
    }

    public long getMinute() {
        return this.minute;
    }

    Snapshot rate(long elapsed) {
        long total = this.getAllTime();
        if (elapsed == 0L) {
            return new Snapshot("rate", total, total, total, total);
        }
        return new Snapshot("rate", total / elapsed, elapsed < 3600L ? total / elapsed : this.getHour() / 3600L, elapsed < 600L ? total / elapsed : this.getTenMinute() / 600L, elapsed < 60L ? total / elapsed : this.getMinute() / 60L);
    }

    public String toString() {
        return "Snapshot{type='" + this.type + '\'' + ", allTime=" + this.allTime + ", hour=" + this.hour + ", tenMinute=" + this.tenMinute + ", minute=" + this.minute + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot snapshot = (Snapshot)o;
        return this.allTime == snapshot.allTime && this.hour == snapshot.hour && this.tenMinute == snapshot.tenMinute && this.minute == snapshot.minute && Objects.equals(this.type, snapshot.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.allTime, this.hour, this.tenMinute, this.minute);
    }
}

