/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.concurrent;

import com.facebook.stats.concurrent.Snapshot;
import com.facebook.stats.concurrent.Stat;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class SpreadStat
implements Stat {
    private static final int WINDOW_COUNT = 3601;
    private static final int TOTAL_INDEX = 0;
    private static final int COUNT_INDEX = 1;
    private static final int MIN_INDEX = 2;
    private static final int MAX_INDEX = 3;
    private final String key;
    private final Clock clock;
    private final long created;
    private final AtomicLong lastRoll;
    private final long[][] rollingWindows = new long[3601][4];
    private final LongAdder total = new LongAdder();
    private final LongAdder count = new LongAdder();
    private final AtomicLong currentMin = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong currentMax = new AtomicLong(Long.MIN_VALUE);
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private int currentOffset;

    public SpreadStat(String key) {
        this(key, Clock.systemUTC());
    }

    public SpreadStat(String key, Clock clock) {
        this.key = key;
        this.clock = clock;
        this.created = clock.millis() / 1000L;
        this.lastRoll = new AtomicLong(this.created);
        for (int i = 0; i < this.rollingWindows.length; ++i) {
            this.rollingWindows[i][2] = Long.MAX_VALUE;
            this.rollingWindows[i][3] = Long.MIN_VALUE;
        }
    }

    @Override
    public void update(long value) {
        this.rollWindows();
        long minValue = this.currentMin.get();
        while (value < minValue && !this.currentMin.compareAndSet(minValue, value)) {
            minValue = this.currentMin.get();
        }
        long maxValue = this.currentMax.get();
        while (value > maxValue && !this.currentMax.compareAndSet(maxValue, value)) {
            maxValue = this.currentMax.get();
        }
        this.total.add(value);
        this.count.increment();
    }

    public String toString() {
        return "SpreadStat{" + this.key + '}';
    }

    public Snapshot getRate() {
        return this.getSum().rate(this.clock.millis() / 1000L - this.created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSum() {
        this.rollWindows();
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            long total = this.total.sum();
            int offset = this.currentOffset + 3601;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Snapshot("sum", total, total - this.rollingWindows[(offset - 3600) % 3601][0], total - this.rollingWindows[(offset - 600) % 3601][0], total - this.rollingWindows[(offset - 60) % 3601][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSamples() {
        this.rollWindows();
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            long count = this.count.sum();
            int offset = this.currentOffset + 3601;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Snapshot("samples", count, count - this.rollingWindows[(offset - 3600) % 3601][1], count - this.rollingWindows[(offset - 600) % 3601][1], count - this.rollingWindows[(offset - 60) % 3601][1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getAverage() {
        this.rollWindows();
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            Snapshot count;
            Snapshot total;
            int currentOffset;
            do {
                currentOffset = this.currentOffset;
                total = this.getSum();
                count = this.getSamples();
            } while (currentOffset != this.currentOffset);
            // ** MonitorExit[var4_1] (shouldn't be in output)
            return new Snapshot("average", SpreadStat.average(total.getAllTime(), count.getAllTime()), SpreadStat.average(total.getHour(), count.getHour()), SpreadStat.average(total.getTenMinute(), count.getTenMinute()), SpreadStat.average(total.getMinute(), count.getMinute()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getMin() {
        this.rollWindows();
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            long hourMin;
            int offset = this.currentOffset + 3601;
            long minuteMin = hourMin = this.currentMin.get();
            long tenMinuteMin = hourMin;
            for (int i = 1; i < 3600; ++i) {
                if (i == 60) {
                    minuteMin = hourMin;
                } else if (i == 600) {
                    tenMinuteMin = hourMin;
                }
                long windowMin = this.rollingWindows[(offset - i) % 3601][2];
                if (hourMin <= windowMin) continue;
                hourMin = windowMin;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Snapshot("min", Math.min(this.min, hourMin), hourMin, tenMinuteMin, minuteMin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getMax() {
        this.rollWindows();
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            long hourMax;
            int offset = this.currentOffset + 3601;
            long minuteMax = hourMax = this.currentMax.get();
            long tenMinuteMax = hourMax;
            for (int i = 1; i < 3600; ++i) {
                if (i == 60) {
                    minuteMax = hourMax;
                } else if (i == 600) {
                    tenMinuteMax = hourMax;
                }
                long windowMax = this.rollingWindows[(offset - i) % 3601][3];
                if (hourMax >= windowMax) continue;
                hourMax = windowMax;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Snapshot("max", Math.max(this.max, hourMax), hourMax, tenMinuteMax, minuteMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rollWindows() {
        long lastRoll;
        long now = this.clock.millis() / 1000L;
        int elapsed = (int)(now - (lastRoll = this.lastRoll.get()));
        if (elapsed < 1 || !this.lastRoll.compareAndSet(lastRoll, now)) return;
        long total = this.total.sum();
        long count = this.count.sum();
        long min = this.currentMin.get();
        long max = this.currentMax.get();
        if (min < this.min) {
            this.min = min;
        }
        if (max > this.max) {
            this.max = max;
        }
        if (elapsed > 3601) {
            elapsed = 3601;
        }
        long[][] lArray = this.rollingWindows;
        synchronized (this.rollingWindows) {
            --elapsed;
            SpreadStat.set(this.rollingWindows[this.currentOffset], total, count, min, max);
            this.currentOffset = this.currentOffset >= 3600 ? 0 : ++this.currentOffset;
            while (elapsed > 0) {
                --elapsed;
                SpreadStat.set(this.rollingWindows[this.currentOffset], total, count, Long.MAX_VALUE, Long.MIN_VALUE);
                if (this.currentOffset >= 3600) {
                    this.currentOffset = 0;
                    continue;
                }
                ++this.currentOffset;
            }
            // ** MonitorExit[var14_8] (shouldn't be in output)
            this.currentMin.compareAndSet(min, Long.MAX_VALUE);
            this.currentMax.compareAndSet(max, Long.MIN_VALUE);
            return;
        }
    }

    private static void set(long[] window, long total, long count, long min, long max) {
        window[0] = total;
        window[1] = count;
        window[2] = min;
        window[3] = max;
    }

    private static long average(long total, long count) {
        return count <= 0L ? 0L : total / count;
    }
}

