/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.config.JSONProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpandedConfJSONProvider
implements JSONProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExpandedConfJSONProvider.class);
    private static final String CONF_KEY = "conf";
    private static final String INCLUDES_KEY = "includes";
    private final String root;

    public AbstractExpandedConfJSONProvider(String root) {
        this.root = root;
    }

    private JSONObject getExpandedJSONConfig() throws JSONException {
        HashSet<String> traversedFiles = new HashSet<String>();
        LinkedList<String> toTraverse = new LinkedList<String>();
        traversedFiles.add(this.root);
        toTraverse.add(this.root);
        JSONObject expanded = new JSONObject();
        while (!toTraverse.isEmpty()) {
            String current = (String)toTraverse.remove();
            JSONObject json = this.load(current);
            JSONObject conf = json.getJSONObject(CONF_KEY);
            Iterator iter = conf.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (expanded.has(key)) continue;
                expanded.put(key, conf.get(key));
            }
            if (!json.has(INCLUDES_KEY)) continue;
            JSONArray includes = json.getJSONArray(INCLUDES_KEY);
            for (int idx = 0; idx < includes.length(); ++idx) {
                String include = this.resolve(current, includes.getString(idx));
                if (traversedFiles.contains(include)) {
                    LOG.warn("Config file was included twice: " + include);
                    continue;
                }
                toTraverse.add(include);
                traversedFiles.add(include);
            }
        }
        return expanded;
    }

    @Override
    public JSONObject get() throws JSONException {
        return this.getExpandedJSONConfig();
    }

    protected abstract String resolve(String var1, String var2);

    protected abstract JSONObject load(String var1) throws JSONException;
}

