/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.config.JSONProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class CompositeJSONProvider
implements JSONProvider {
    private final List<JSONProvider> jsonProviderList;

    public CompositeJSONProvider(List<JSONProvider> jsonProviderList) {
        this.jsonProviderList = jsonProviderList;
    }

    public CompositeJSONProvider(JSONProvider ... jsonProviders) {
        this(Arrays.asList(jsonProviders));
    }

    @Override
    public JSONObject get() throws JSONException {
        JSONObject mergedJsonObject = new JSONObject();
        for (JSONProvider jsonProvider : this.jsonProviderList) {
            JSONObject jsonObject = jsonProvider.get();
            this.mergeInto(mergedJsonObject, jsonObject);
        }
        return mergedJsonObject;
    }

    private JSONObject mergeInto(JSONObject destinationJsonObject, JSONObject sourceJsonObject) throws JSONException {
        Iterator keys = sourceJsonObject.keys();
        while (keys.hasNext()) {
            String sourceKey = (String)keys.next();
            Object sourceValue = sourceJsonObject.get(sourceKey);
            if (sourceValue instanceof JSONObject && destinationJsonObject.has(sourceKey) && destinationJsonObject.get(sourceKey) instanceof JSONObject) {
                destinationJsonObject.put(sourceKey, (Object)this.mergeInto((JSONObject)destinationJsonObject.get(sourceKey), (JSONObject)sourceValue));
                continue;
            }
            destinationJsonObject.put(sourceKey, sourceValue);
        }
        return destinationJsonObject;
    }
}

