/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.collections.ByteArray;
import com.facebook.collectionsbase.Mapper;
import com.facebook.config.BooleanExtractor;
import com.facebook.config.ClassExtractor;
import com.facebook.config.ConfigException;
import com.facebook.config.ConfigUtil;
import com.facebook.config.DoubleExtractor;
import com.facebook.config.ExtractableBeanBuilder;
import com.facebook.config.Extractor;
import com.facebook.config.FieldExtractor;
import com.facebook.config.IntegerExtractor;
import com.facebook.config.JSONObjectExtractor;
import com.facebook.config.LongExtractor;
import com.facebook.config.StringExtractor;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigAccessor {
    private static final Logger LOG = LoggerImpl.getClassLogger();
    private final JSONObject jsonObject;

    public ConfigAccessor(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public static ConfigAccessor emptyConfig() {
        return new ConfigAccessor(new JSONObject());
    }

    public <T> T getBean(String key, Class<? extends ExtractableBeanBuilder<T>> beanBuilderClass) {
        try {
            JSONObject jsonBean = this.get(key, null, new JSONObjectExtractor());
            ConfigAccessor jsonBeanAccessor = new ConfigAccessor(jsonBean);
            ExtractableBeanBuilder<T> beanBuilder = beanBuilderClass.newInstance();
            for (Method m : beanBuilderClass.getMethods()) {
                if (!m.getName().toLowerCase().startsWith("set")) continue;
                FieldExtractor extractor = m.getAnnotation(FieldExtractor.class);
                if (extractor != null) {
                    if (!Extractor.class.isAssignableFrom(extractor.extractorClass())) {
                        String message = String.format("extractor %s does not extend Extractor.class", extractor);
                        LOG.error(message, new Object[0]);
                        throw new ConfigException(message);
                    }
                    if (extractor.optional() && !jsonBeanAccessor.hasKey(extractor.key())) continue;
                    Object value = jsonBeanAccessor.get(extractor.key(), null, (Extractor)extractor.extractorClass().newInstance());
                    m.invoke(beanBuilder, value);
                    continue;
                }
                LOG.warn("unable to find annotation for setter method " + m.getName(), new Object[0]);
            }
            return beanBuilder.build();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigException(e);
        }
    }

    public Class<?> getClass(String key, Class<?> defaultValue) {
        return this.get(key, defaultValue, new ClassExtractor());
    }

    public boolean hasKey(String key) {
        return this.jsonObject.has(key);
    }

    public Duration getDuration(String key, String defaultValue) {
        return new Duration(this.getDurationMillis(key, defaultValue));
    }

    public long getDurationSeconds(String key, String defaultValue) {
        return ConfigUtil.getDurationMillis(this.getString(key, defaultValue)) / 1000L;
    }

    public long getDurationMillis(String key, String defaultValue) {
        return ConfigUtil.getDurationMillis(this.getString(key, defaultValue));
    }

    public long getSizeBytes(String key, String defaultValue) {
        return ConfigUtil.getSizeBytes(this.getString(key, defaultValue));
    }

    public long getSizeBytes(String key, Long defaultValue) {
        return this.hasKey(key) ? ConfigUtil.getSizeBytes(this.getString(key)) : defaultValue;
    }

    public Boolean getBoolean(String key) throws ConfigException {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) throws ConfigException {
        return this.get(key, defaultValue, new BooleanExtractor());
    }

    public String getString(String key) throws ConfigException {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, defaultValue, new StringExtractor());
    }

    public int getInt(String key) throws ConfigException {
        return this.getInt(key, null);
    }

    public int getInt(String key, Integer defaultValue) {
        return this.get(key, defaultValue, new IntegerExtractor());
    }

    public long getLong(String key) throws ConfigException {
        return this.getLong(key, null);
    }

    public long getLong(String key, Long defaultValue) {
        return this.get(key, defaultValue, new LongExtractor());
    }

    public double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public double getDouble(String key, Double defaultValue) {
        return this.get(key, defaultValue, new DoubleExtractor());
    }

    public Map<String, String> getStringMap(String key) {
        return this.get(key, null, new Extractor<Map<String, String>>(){

            @Override
            public Map<String, String> extract(String key, JSONObject jsonObject) throws JSONException {
                HashMap<String, String> map = new HashMap<String, String>();
                JSONObject jsonMap = jsonObject.getJSONObject(key);
                ConfigAccessor mapAccessor = new ConfigAccessor(jsonMap);
                Iterator keys = jsonMap.keys();
                while (keys.hasNext()) {
                    String mapKey = (String)keys.next();
                    map.put(mapKey, mapAccessor.getString(mapKey));
                }
                return map;
            }
        });
    }

    public <T> List<T> getList(String key, Mapper<String, T> converter) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : this.getStringList(key)) {
            result.add(converter.map((Object)item));
        }
        return result;
    }

    public List<String> getStringList(String key) throws ConfigException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            JSONArray items = this.jsonObject.getJSONArray(key);
            for (int i = 0; i < items.length(); ++i) {
                result.add(items.getString(i));
            }
        }
        catch (JSONException e) {
            throw new ConfigException("unable to parse string list for key " + key, e);
        }
        return result;
    }

    public List<ByteArray> getByteArrayList(String key) throws ConfigException {
        ArrayList<ByteArray> result = new ArrayList<ByteArray>();
        for (String item : this.getStringList(key)) {
            result.add(ByteArray.wrap((byte[])item.getBytes()));
        }
        return result;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator keysIterator = this.jsonObject.keys();
        while (keysIterator.hasNext()) {
            keys.add((String)keysIterator.next());
        }
        return keys;
    }

    public Map<String, String> getConfigAsMap() {
        HashMap configAsMap = Maps.newHashMap();
        Iterator keysIterator = this.jsonObject.keys();
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            try {
                configAsMap.put(key, this.jsonObject.getString(key));
            }
            catch (JSONException e) {
                LOG.warn((Throwable)e, "unable to extract key %s as a string in config", new Object[]{key});
            }
        }
        return configAsMap;
    }

    private <T> T get(String key, T defaultValue, Extractor<T> extractor) throws ConfigException {
        try {
            if (this.jsonObject.has(key)) {
                return extractor.extract(key, this.jsonObject);
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new ConfigException("missing property: " + key);
        }
        catch (JSONException e) {
            throw new ConfigException(e);
        }
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public String toString(int indentFactor) throws ConfigException {
        try {
            return this.jsonObject.toString(indentFactor);
        }
        catch (JSONException e) {
            throw new ConfigException(e);
        }
    }
}

