/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.config.ConfigAccessor;
import com.facebook.config.ConfigException;
import com.facebook.config.ExpandedConfFileJSONProvider;
import com.facebook.config.JSONProvider;
import com.facebook.config.RefreshableConfigProvider;
import com.facebook.config.SystemPropOverridingJSONProvider;
import java.io.File;
import org.json.JSONException;

public class ConfigProviderImpl
implements RefreshableConfigProvider {
    private final JSONProvider jsonProvider;
    private final Object lock = new Object();
    private volatile ConfigAccessor config;

    public ConfigProviderImpl(JSONProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public ConfigProviderImpl(File file) {
        this(new SystemPropOverridingJSONProvider(new ExpandedConfFileJSONProvider(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigAccessor getConfig() {
        if (this.config == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.config == null) {
                    this.refresh();
                }
            }
        }
        return this.config;
    }

    @Override
    public void refresh() {
        try {
            this.config = new ConfigAccessor(this.jsonProvider.get());
        }
        catch (JSONException e) {
            throw new ConfigException(e);
        }
    }
}

