/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.config.ConfigException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigUtil {
    private static final Pattern NUMBER_AND_UNIT = Pattern.compile("(\\d+)([a-zA-Z]+)?");

    public static long getDurationMillis(String duration) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(duration);
        if (matcher.matches()) {
            long number = Long.valueOf(matcher.group(1));
            if (matcher.group(2) != null) {
                String unitStr = matcher.group(2).toLowerCase();
                char unit = unitStr.charAt(0);
                switch (unit) {
                    case 's': {
                        return number * 1000L;
                    }
                    case 'm': {
                        if (unitStr.length() >= 2 && unitStr.charAt(1) == 's') {
                            return number;
                        }
                        return number * 60L * 1000L;
                    }
                    case 'h': {
                        return number * 60L * 60L * 1000L;
                    }
                    case 'd': {
                        return number * 60L * 60L * 24L * 1000L;
                    }
                    case 'y': {
                        return number * 365L * 60L * 60L * 24L * 1000L;
                    }
                }
                throw new ConfigException("unknown time unit :" + unit);
            }
            return number;
        }
        throw new ConfigException("malformed duration string: " + duration);
    }

    public static long getSizeBytes(String size) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(size);
        if (matcher.matches()) {
            long number = Long.valueOf(matcher.group(1));
            if (matcher.group(2) != null) {
                char unit = matcher.group(2).toLowerCase().charAt(0);
                switch (unit) {
                    case 'b': {
                        return number;
                    }
                    case 'k': {
                        return number * 1024L;
                    }
                    case 'm': {
                        return number * 1024L * 1024L;
                    }
                    case 'g': {
                        return number * 1024L * 1024L * 1024L;
                    }
                }
                throw new ConfigException("unknown size unit :" + unit);
            }
            return number;
        }
        throw new ConfigException("malformed size string: " + size);
    }
}

