/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config;

import com.facebook.config.JSONProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class FileJSONProvider
implements JSONProvider {
    private static final Pattern COMMENT_LINE = Pattern.compile("^\\s*//.*");
    private final File file;

    public FileJSONProvider(File file) {
        this.file = file;
    }

    protected BufferedReader getReader() throws FileNotFoundException {
        return new BufferedReader(new FileReader(this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject fileToJSON() throws IOException, JSONException {
        StringBuilder sb = new StringBuilder(1024);
        try (BufferedReader in = null;){
            String line;
            in = this.getReader();
            while ((line = in.readLine()) != null) {
                if (COMMENT_LINE.matcher(line).find()) continue;
                sb.append(line);
            }
        }
        return new JSONObject(sb.toString());
    }

    @Override
    public JSONObject get() throws JSONException {
        try {
            return this.fileToJSON();
        }
        catch (IOException e) {
            throw new JSONException((Throwable)e);
        }
    }
}

