/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.config.dynamic;

import com.facebook.config.dynamic.Option;
import com.facebook.config.dynamic.OptionWatcher;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.google.common.collect.Lists;
import java.util.List;

public class OptionImpl<V>
implements Option<V> {
    private static final Logger LOG = LoggerImpl.getClassLogger();
    private final List<OptionWatcher<V>> watchers = Lists.newCopyOnWriteArrayList();
    private volatile V value;

    public OptionImpl() {
    }

    public OptionImpl(V value) {
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(V value) {
        this.value = value;
        for (OptionWatcher<V> watcher : this.watchers) {
            this.notifyWatcher(watcher, value);
        }
    }

    @Override
    public void addWatcher(OptionWatcher<V> watcher) {
        if (!this.watchers.contains(watcher)) {
            this.watchers.add(watcher);
        }
    }

    @Override
    public void removeWatcher(OptionWatcher<V> watcher) {
        this.watchers.remove(watcher);
    }

    private void notifyWatcher(OptionWatcher<V> watcher, V value) {
        try {
            watcher.propertyUpdated(value);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Problem running property watcher for value update: %s", new Object[]{value});
        }
    }
}

