/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.lifecycle;

import com.facebook.lifecycle.ShutdownManager;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ShutdownManagerImpl<T extends Enum>
implements ShutdownManager<T> {
    private static final Logger LOG = LoggerImpl.getLogger(ShutdownManagerImpl.class);
    private final Map<T, List<Runnable>> shutdownHooksByStage = new ConcurrentHashMap<T, List<Runnable>>();
    private final Thread thread;
    private final Object shutdownLock = new Object();
    private final T[] stages;
    private final T firstStage;
    private final T lastStage;
    private final T defaultStage;
    private T currentStage;
    private boolean isShutdown = false;

    public ShutdownManagerImpl(Class<T> enumClazz, T defaultStage) {
        this.defaultStage = defaultStage;
        if (!enumClazz.isEnum()) {
            throw new IllegalArgumentException(String.format("%s is not an enum class", enumClazz.getName()));
        }
        for (T stage : this.stages = (Enum[])enumClazz.getEnumConstants()) {
            this.shutdownHooksByStage.put(stage, new ArrayList());
        }
        if (this.stages.length < 3) {
            throw new IllegalArgumentException("enum class must have at least 3 values");
        }
        this.firstStage = this.stages[0];
        this.currentStage = this.firstStage;
        this.lastStage = this.stages[this.stages.length - 1];
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ShutdownManagerImpl.this.internalShutdown();
            }
        });
    }

    @Override
    public boolean tryAddShutdownHook(Runnable hook) {
        return this.tryAddShutdownHook(this.defaultStage, hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAddShutdownHook(T stage, Runnable hook) {
        if (stage == this.firstStage || stage == this.lastStage) {
            throw new IllegalArgumentException(String.format("stage %s is reserved", stage));
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            if (((Enum)stage).compareTo(this.currentStage) <= 0) {
                LOG.warn("cannot add hook for stage %s when in stage %s", new Object[]{stage, this.currentStage});
                return false;
            }
            this.shutdownHooksByStage.get(stage).add(hook);
            return true;
        }
    }

    @Override
    public void addShutdownHook(Runnable hook) {
        this.addShutdownHook(this.defaultStage, hook);
    }

    @Override
    public void addShutdownHook(T stage, Runnable hook) {
        if (!this.tryAddShutdownHook(stage, hook)) {
            throw new IllegalStateException("trying to add a hook after shutdown started");
        }
    }

    @Override
    public void shutdown() {
        if (this.internalShutdown()) {
            Runtime.getRuntime().removeShutdownHook(this.thread);
        }
    }

    @Override
    public Thread getAsThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalShutdown() {
        T[] TArray = this.shutdownLock;
        synchronized (this.shutdownLock) {
            if (this.isShutdown) {
                LOG.info("ignoring extra shutdown call", new Object[0]);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this.isShutdown = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOG.info("starting service shutdown hooks", new Object[0]);
            for (T stage : this.stages) {
                LOG.info("starting stage " + stage, new Object[0]);
                Iterator<Runnable> iterator = this.shutdownLock;
                synchronized (iterator) {
                    this.currentStage = stage;
                }
                for (Runnable hook : this.shutdownHooksByStage.get(stage)) {
                    try {
                        hook.run();
                    }
                    catch (Throwable t) {
                        LOG.warn("error running hook", t);
                    }
                }
                LOG.info("ending stage " + stage, new Object[0]);
            }
            LOG.info("shutdown complete", new Object[0]);
            return true;
        }
    }
}

