/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging.log4j;

import com.facebook.logging.log4j.RollingCalendar;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CustodianLog4JDailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String compressBackups = "false";
    private String maxNumberOfDays = "7";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public CustodianLog4JDailyRollingFileAppender() {
    }

    public CustodianLog4JDailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.cleanupAndRollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"cleanupAndRollover() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    public String getCompressBackups() {
        return this.compressBackups;
    }

    public void setCompressBackups(String compressBackups) {
        this.compressBackups = compressBackups;
    }

    public String getMaxNumberOfDays() {
        return this.maxNumberOfDays;
    }

    public void setMaxNumberOfDays(String maxNumberOfDays) {
        this.maxNumberOfDays = maxNumberOfDays;
    }

    protected void cleanupAndRollOver() throws IOException {
        File file = new File(this.fileName);
        Calendar cal = Calendar.getInstance();
        int maxDays = 7;
        try {
            maxDays = Integer.parseInt(this.getMaxNumberOfDays());
        }
        catch (Exception exception) {
            // empty catch block
        }
        cal.add(5, -maxDays);
        Date cutoffDate = cal.getTime();
        if (file.getParentFile().exists()) {
            File[] files = file.getParentFile().listFiles(new StartsWithFileFilter(file.getName(), false));
            int nameLength = file.getName().length();
            for (int i = 0; i < files.length; ++i) {
                String datePart = null;
                try {
                    datePart = files[i].getName().substring(nameLength);
                    Date date = this.sdf.parse(datePart);
                    if (date.before(cutoffDate)) {
                        files[i].delete();
                        continue;
                    }
                    if (!this.getCompressBackups().equalsIgnoreCase("YES") && !this.getCompressBackups().equalsIgnoreCase("TRUE")) continue;
                    this.zipAndDelete(files[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.rollOver();
    }

    private void zipAndDelete(File file) throws IOException {
        if (!file.getName().endsWith(".zip")) {
            int bytesRead;
            File zipFile = new File(file.getParent(), file.getName() + ".zip");
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            zos.closeEntry();
            fis.close();
            zos.close();
            file.delete();
        }
    }

    class StartsWithFileFilter
    implements FileFilter {
        private String startsWith;
        private boolean inclDirs = false;

        public StartsWithFileFilter(String startsWith, boolean includeDirectories) {
            this.startsWith = startsWith.toUpperCase();
            this.inclDirs = includeDirectories;
        }

        @Override
        public boolean accept(File pathname) {
            if (!this.inclDirs && pathname.isDirectory()) {
                return false;
            }
            return pathname.getName().toUpperCase().startsWith(this.startsWith);
        }
    }
}

