/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class TimeSamplingSLF4JLogger
implements Logger {
    private final Logger logger;
    private final long windowSizeMillis;
    private final AtomicBoolean logToggle = new AtomicBoolean(false);
    private volatile long lastLoggedMillis = 0L;

    public TimeSamplingSLF4JLogger(Logger logger, long time, TimeUnit timeUnit) {
        this.logger = logger;
        this.windowSizeMillis = timeUnit.toMillis(time);
    }

    private boolean shouldLog() {
        if (DateTimeUtils.currentTimeMillis() - this.lastLoggedMillis >= this.windowSizeMillis && this.logToggle.compareAndSet(false, true)) {
            try {
                this.lastLoggedMillis = DateTimeUtils.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            finally {
                this.logToggle.set(false);
            }
        }
        return false;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.shouldLog()) {
            this.logger.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.debug(format, args);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.debug(message, throwable);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.logger.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.logger.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.shouldLog()) {
            this.logger.debug(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.info(format, arg1, arg2);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.shouldLog()) {
            this.logger.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.warn(format, arg);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.shouldLog()) {
            this.logger.error(msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.error(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.info(format, args);
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.info(message, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.logger.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.logger.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.info(marker, msg, t);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.warn(format, args);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.warn(format, arg1, arg2);
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.warn(message, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.logger.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.logger.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.warn(marker, msg, t);
        }
    }

    public void error(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.error(format, args);
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.error(message, throwable);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.logger.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.logger.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.error(marker, msg, t);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.shouldLog()) {
            this.logger.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.shouldLog()) {
            this.logger.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.shouldLog()) {
            this.logger.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.shouldLog()) {
            this.logger.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldLog()) {
            this.logger.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.shouldLog()) {
            this.logger.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.shouldLog()) {
            this.logger.trace(marker, msg, t);
        }
    }
}

