/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging;

import com.facebook.logging.Logger;
import org.slf4j.LoggerFactory;

public class LoggerImpl
implements Logger {
    private final org.slf4j.Logger logger;

    public LoggerImpl(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        org.slf4j.Logger logger = LoggerFactory.getLogger(clazz);
        return new LoggerImpl(logger);
    }

    public static Logger getLogger(String name) {
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)name);
        return new LoggerImpl(logger);
    }

    public static Logger getClassLogger() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement element = stacktrace[2];
        String name = element.getClassName();
        return new LoggerImpl(LoggerFactory.getLogger((String)name));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.formatMessage(format, args));
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.formatMessage(format, args), t);
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.debug(message);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.debug(message, t);
        }
    }

    @Override
    @Deprecated
    public void debug(String message, Throwable throwable) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, throwable);
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.info(message);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.info(message, t);
        }
    }

    @Override
    @Deprecated
    public void info(String message, Throwable throwable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.warn(message, throwable);
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.warn(message);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.warn(message, t);
        }
    }

    @Override
    @Deprecated
    public void warn(String message, Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, throwable);
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.error(message);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            String message = this.formatMessage(format, args);
            this.logger.error(message, t);
        }
    }

    @Override
    @Deprecated
    public void error(String message, Throwable throwable) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, throwable);
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    private String formatMessage(String format, Object[] args) {
        return args.length == 0 ? format : String.format(format, args);
    }
}

