/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.joda.time.DateTimeUtils;

public class TimeSamplingLog4jLogger {
    private final Logger logger;
    private final long windowSizeMillis;
    private final AtomicBoolean logToggle = new AtomicBoolean(false);
    private volatile long lastLoggedMillis = 0L;

    public TimeSamplingLog4jLogger(Logger logger, long time, TimeUnit timeUnit) {
        this.logger = logger;
        this.windowSizeMillis = timeUnit.toMillis(time);
    }

    private boolean shouldLog() {
        if (DateTimeUtils.currentTimeMillis() - this.lastLoggedMillis >= this.windowSizeMillis && this.logToggle.compareAndSet(false, true)) {
            try {
                this.lastLoggedMillis = DateTimeUtils.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            finally {
                this.logToggle.set(false);
            }
        }
        return false;
    }

    public void debug(String format, Object ... args) {
        if (this.shouldLog() && this.logger.isDebugEnabled()) {
            String message = String.format(format, args);
            this.logger.debug((Object)message);
        }
    }

    public void debug(Throwable t, String format, Object ... args) {
        if (this.shouldLog() && this.logger.isDebugEnabled()) {
            String message = String.format(format, args);
            this.logger.debug((Object)message, t);
        }
    }

    public void info(String format, Object ... args) {
        if (this.shouldLog() && this.logger.isInfoEnabled()) {
            String message = String.format(format, args);
            this.logger.info((Object)message);
        }
    }

    public void info(Throwable t, String format, Object ... args) {
        if (this.shouldLog() && this.logger.isInfoEnabled()) {
            String message = String.format(format, args);
            this.logger.info((Object)message, t);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.shouldLog() && this.logger.isEnabledFor((Priority)Level.WARN)) {
            String message = String.format(format, args);
            this.logger.warn((Object)message);
        }
    }

    public void warn(Throwable t, String format, Object ... args) {
        if (this.shouldLog() && this.logger.isEnabledFor((Priority)Level.WARN)) {
            String message = String.format(format, args);
            this.logger.warn((Object)message, t);
        }
    }

    public void error(String format, Object ... args) {
        if (this.shouldLog() && this.logger.isEnabledFor((Priority)Level.ERROR)) {
            String message = String.format(format, args);
            this.logger.error((Object)message);
        }
    }

    public void error(Throwable t, String format, Object ... args) {
        if (this.shouldLog() && this.logger.isEnabledFor((Priority)Level.ERROR)) {
            String message = String.format(format, args);
            this.logger.error((Object)message, t);
        }
    }
}

