/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging;

import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import java.util.Collection;

public class CompositeLogger
implements Logger {
    private static final Logger LOG = LoggerImpl.getClassLogger();
    private final Collection<Logger> loggers;

    public CompositeLogger(Collection<Logger> loggers) {
        this.loggers = loggers;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.accumulate(new OrAccumulator(){

            @Override
            protected boolean getValue(Logger log) {
                return log.isTraceEnabled();
            }
        });
    }

    @Override
    public boolean isDebugEnabled() {
        return this.accumulate(new OrAccumulator(){

            @Override
            protected boolean getValue(Logger log) {
                return log.isDebugEnabled();
            }
        });
    }

    @Override
    public boolean isInfoEnabled() {
        return this.accumulate(new OrAccumulator(){

            @Override
            protected boolean getValue(Logger log) {
                return log.isInfoEnabled();
            }
        });
    }

    @Override
    public boolean isWarnEnabled() {
        return this.accumulate(new OrAccumulator(){

            @Override
            protected boolean getValue(Logger log) {
                return log.isWarnEnabled();
            }
        });
    }

    @Override
    public boolean isErrorEnabled() {
        return this.accumulate(new OrAccumulator(){

            @Override
            protected boolean getValue(Logger log) {
                return log.isErrorEnabled();
            }
        });
    }

    @Override
    public void trace(final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isTraceEnabled()) {
                    log.trace(format, args);
                }
            }
        });
    }

    @Override
    public void trace(final Throwable t, final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isTraceEnabled()) {
                    log.trace(t, format, args);
                }
            }
        });
    }

    @Override
    public void debug(final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isDebugEnabled()) {
                    log.debug(format, args);
                }
            }
        });
    }

    @Override
    public void debug(final Throwable t, final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isDebugEnabled()) {
                    log.debug(t, format, args);
                }
            }
        });
    }

    @Override
    public void debug(final String message, final Throwable throwable) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isDebugEnabled()) {
                    log.debug(throwable, message, new Object[0]);
                }
            }
        });
    }

    @Override
    public void info(final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isInfoEnabled()) {
                    log.info(format, args);
                }
            }
        });
    }

    @Override
    public void info(final Throwable t, final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isInfoEnabled()) {
                    log.info(t, format, args);
                }
            }
        });
    }

    @Override
    public void info(final String message, final Throwable throwable) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isInfoEnabled()) {
                    log.info(throwable, message, new Object[0]);
                }
            }
        });
    }

    @Override
    public void warn(final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isWarnEnabled()) {
                    log.warn(format, args);
                }
            }
        });
    }

    @Override
    public void warn(final Throwable t, final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isWarnEnabled()) {
                    log.warn(t, format, args);
                }
            }
        });
    }

    @Override
    public void warn(final String message, final Throwable throwable) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isWarnEnabled()) {
                    log.warn(throwable, message, new Object[0]);
                }
            }
        });
    }

    @Override
    public void error(final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isErrorEnabled()) {
                    log.error(format, args);
                }
            }
        });
    }

    @Override
    public void error(final Throwable t, final String format, final Object ... args) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isErrorEnabled()) {
                    log.error(t, format, args);
                }
            }
        });
    }

    @Override
    public void error(final String message, final Throwable throwable) {
        this.logAll(new LoggerOperation(){

            @Override
            public void execute(Logger log) {
                if (log.isErrorEnabled()) {
                    log.error(throwable, message, new Object[0]);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.loggers.toString();
    }

    private boolean accumulate(Accumulator accumulator) {
        for (Logger log : this.loggers) {
            accumulator.accumulate(log);
        }
        return accumulator.result();
    }

    private void logAll(LoggerOperation loggerOperation) {
        for (Logger log : this.loggers) {
            try {
                loggerOperation.execute(log);
            }
            catch (Exception e) {
                LOG.error(e, "error writing to logger %s", log.getName());
            }
        }
    }

    private static abstract class OrAccumulator
    implements Accumulator {
        private boolean value = false;

        private OrAccumulator() {
        }

        protected abstract boolean getValue(Logger var1);

        @Override
        public boolean accumulate(Logger log) {
            return this.value |= this.getValue(log);
        }

        @Override
        public boolean result() {
            return this.value;
        }
    }

    private static interface LoggerOperation {
        public void execute(Logger var1);
    }

    private static interface Accumulator {
        public boolean accumulate(Logger var1);

        public boolean result();
    }
}

