/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.logging;

import com.facebook.logging.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTimeUtils;

public class TimeSamplingLogger
implements Logger {
    private final Logger logger;
    private final long windowSizeMillis;
    private final AtomicBoolean logToggle = new AtomicBoolean(false);
    private volatile long lastLoggedMillis = 0L;

    public TimeSamplingLogger(Logger logger, long time, TimeUnit timeUnit) {
        this.logger = logger;
        this.windowSizeMillis = timeUnit.toMillis(time);
    }

    private boolean shouldLog() {
        if (DateTimeUtils.currentTimeMillis() - this.lastLoggedMillis >= this.windowSizeMillis && this.logToggle.compareAndSet(false, true)) {
            try {
                this.lastLoggedMillis = DateTimeUtils.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            finally {
                this.logToggle.set(false);
            }
        }
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.trace(format, args);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.trace(t, format, args);
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.debug(format, args);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.debug(t, format, args);
        }
    }

    @Override
    @Deprecated
    public void debug(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.debug(message, throwable);
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.info(format, args);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.info(t, format, args);
        }
    }

    @Override
    @Deprecated
    public void info(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.info(message, throwable);
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.warn(format, args);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.warn(t, format, args);
        }
    }

    @Override
    @Deprecated
    public void warn(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.warn(message, throwable);
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.error(format, args);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... args) {
        if (this.shouldLog()) {
            this.logger.error(t, format, args);
        }
    }

    @Override
    @Deprecated
    public void error(String message, Throwable throwable) {
        if (this.shouldLog()) {
            this.logger.error(message, throwable);
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }
}

