/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.AbstractCompositeCounter;
import com.facebook.stats.EventCounter;
import com.facebook.stats.MaxEventCounter;
import java.util.Arrays;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;

public class CompositeMax
extends AbstractCompositeCounter<EventCounter>
implements EventCounter {
    public CompositeMax(ReadableDuration maxLength, ReadableDuration maxChunkLength) {
        super(maxLength, maxChunkLength);
    }

    public CompositeMax(ReadableDuration maxLength) {
        super(maxLength);
    }

    @Override
    public EventCounter merge(EventCounter counter) {
        if (counter instanceof CompositeMax) {
            return this.internalMerge(((CompositeMax)counter).getEventCounters(), new CompositeMax(this.getMaxLength(), this.getMaxChunkLength()));
        }
        return this.internalMerge(Arrays.asList(counter), new CompositeMax(this.getMaxLength(), this.getMaxChunkLength()));
    }

    @Override
    protected EventCounter nextCounter(ReadableDateTime start, ReadableDateTime end) {
        return new MaxEventCounter(start, end);
    }

    @Override
    public synchronized long getValue() {
        this.trimIfNeeded();
        long max = Long.MIN_VALUE;
        for (EventCounter eventCounter : this.getEventCounters()) {
            max = Math.max(max, eventCounter.getValue());
        }
        return max;
    }
}

