/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.FacebookStatsReporter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CounterCacher {
    private static final ThreadGroup threadGroup = new ThreadGroup("CounterCacher");
    private static final ThreadFactory threadFactory = new ThreadFactory();
    private volatile Thread thread;
    private final Runnable runnable;
    private final FacebookStatsReporter reporter;
    private volatile boolean running = false;
    private volatile boolean wantRunning = false;
    private volatile Map<String, Long> counters;

    public CounterCacher(FacebookStatsReporter reporter, long minWait, long maxWait) {
        this.runnable = new CounterCacherRunner(minWait, maxWait);
        this.reporter = reporter;
    }

    public CounterCacher(FacebookStatsReporter reporter, long minWait) {
        this(reporter, minWait, minWait);
    }

    public CounterCacher(FacebookStatsReporter reporter) {
        this(reporter, 1000L);
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("start() called while already running!");
        }
        this.thread = threadFactory.newThread(this.runnable);
        this.thread.start();
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("stop() called while not running!");
        }
        this.wantRunning = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public Map<String, Long> getCounters() {
        return this.counters;
    }

    private class CounterCacherRunner
    implements Runnable {
        private final long minWait;
        private final long maxWait;

        public CounterCacherRunner(long minWait, long maxWait) {
            this.minWait = minWait;
            this.maxWait = maxWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Logger log = Logger.getLogger(CounterCacher.class.getCanonicalName());
            CounterCacher.this.wantRunning = true;
            CounterCacher.this.running = true;
            log.log(Level.INFO, "Cacheing counters every " + this.minWait + " - " + this.maxWait + " msec");
            try {
                while (CounterCacher.this.wantRunning) {
                    try {
                        long startTime = System.currentTimeMillis();
                        CounterCacher.this.counters = CounterCacher.this.reporter.makeCounters();
                        Thread.sleep(this.minWait);
                        long runTime = System.currentTimeMillis() - startTime;
                        long remainingWait = this.maxWait - runTime;
                        if (remainingWait <= 0L) continue;
                        Thread.sleep(remainingWait);
                    }
                    catch (InterruptedException iex) {
                        CounterCacher.this.wantRunning = false;
                    }
                }
                return;
            }
            catch (RuntimeException rex) {
                log.log(Level.SEVERE, "RuntimeException thrown while running makeCounters()", rex);
                return;
            }
            finally {
                CounterCacher.this.running = false;
            }
        }
    }

    private static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        long count = 0L;

        private ThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            ++this.count;
            return new Thread(threadGroup, r, threadGroup.getName() + "-" + this.count);
        }
    }
}

