/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.GaugeCounter;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class DefaultGaugeCounter
implements GaugeCounter {
    private final ReadableDateTime start;
    private final ReadableDateTime end;
    private long value = 0L;
    private long nsamples = 0L;

    public DefaultGaugeCounter(ReadableDateTime start, ReadableDateTime end) {
        if (start.isAfter((ReadableInstant)end)) {
            this.start = end;
            this.end = start;
        } else {
            this.start = start;
            this.end = end;
        }
    }

    @Override
    public synchronized void add(long delta, long samples) {
        this.value += delta;
        this.nsamples += samples;
    }

    @Override
    public synchronized void add(long delta) {
        this.add(delta, 1L);
    }

    @Override
    public synchronized long getValue() {
        return this.value;
    }

    @Override
    public synchronized long getSamples() {
        return this.nsamples;
    }

    @Override
    public synchronized long getAverage() {
        if (this.nsamples == 0L) {
            return 0L;
        }
        return this.value / this.nsamples;
    }

    @Override
    public ReadableDateTime getStart() {
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        return this.end;
    }

    @Override
    public Duration getLength() {
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public GaugeCounter merge(GaugeCounter counter) {
        ReadableDateTime mergedStart = this.start;
        ReadableDateTime mergedEnd = this.end;
        if (counter.getStart().isBefore((ReadableInstant)mergedStart)) {
            mergedStart = counter.getStart();
        }
        if (counter.getEnd().isAfter((ReadableInstant)mergedEnd)) {
            mergedEnd = counter.getEnd();
        }
        DefaultGaugeCounter mergedCounter = new DefaultGaugeCounter(mergedStart, mergedEnd);
        mergedCounter.add(this.value + counter.getValue(), this.nsamples + counter.getSamples());
        return mergedCounter;
    }
}

