/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.EventCounter;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class EventCounterImpl
implements EventCounter {
    private final ReadableDateTime start;
    private final ReadableDateTime end;
    private final AtomicLong value;

    public EventCounterImpl(ReadableDateTime start, ReadableDateTime end, long initialValue) {
        if (start.isAfter((ReadableInstant)end)) {
            this.start = end;
            this.end = start;
        } else {
            this.start = start;
            this.end = end;
        }
        this.value = new AtomicLong(initialValue);
    }

    public EventCounterImpl(ReadableDateTime start, ReadableDateTime end) {
        this(start, end, 0L);
    }

    @Override
    public void add(long delta) {
        this.value.addAndGet(delta);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public ReadableDateTime getStart() {
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        return this.end;
    }

    @Override
    public Duration getLength() {
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public EventCounter merge(EventCounter counter) {
        ReadableDateTime mergedStart = this.start;
        ReadableDateTime mergedEnd = this.end;
        if (counter.getStart().isBefore((ReadableInstant)mergedStart)) {
            mergedStart = counter.getStart();
        }
        if (counter.getEnd().isAfter((ReadableInstant)mergedEnd)) {
            mergedEnd = counter.getEnd();
        }
        EventCounterImpl mergedCounter = new EventCounterImpl(mergedStart, mergedEnd);
        mergedCounter.add(this.value.get() + counter.getValue());
        return mergedCounter;
    }
}

