/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.ExponentialDecay;
import com.facebook.stats.QuantileDigest;
import com.facebook.stats.WritableMultiWindowStat;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiWindowDistribution
implements WritableMultiWindowStat {
    private final QuantileDigest oneMinute;
    private final QuantileDigest tenMinutes;
    private final QuantileDigest oneHour;
    private final QuantileDigest allTime;

    @VisibleForTesting
    MultiWindowDistribution(QuantileDigest oneMinute, QuantileDigest tenMinutes, QuantileDigest oneHour, QuantileDigest allTime) {
        this.oneMinute = oneMinute;
        this.tenMinutes = tenMinutes;
        this.oneHour = oneHour;
        this.allTime = allTime;
    }

    public MultiWindowDistribution() {
        this(new QuantileDigest(0.01, ExponentialDecay.computeAlpha(0.1, 60)), new QuantileDigest(0.01, ExponentialDecay.computeAlpha(0.1, 600)), new QuantileDigest(0.01, ExponentialDecay.computeAlpha(0.1, 3600)), new QuantileDigest(0.01));
    }

    @Override
    public void add(long value) {
        this.oneMinute.add(value);
        this.tenMinutes.add(value);
        this.oneHour.add(value);
        this.allTime.add(value);
    }

    public QuantileDigest getOneMinute() {
        return this.oneMinute;
    }

    public QuantileDigest getTenMinutes() {
        return this.tenMinutes;
    }

    public QuantileDigest getOneHour() {
        return this.oneHour;
    }

    public QuantileDigest getAllTime() {
        return this.allTime;
    }

    public Map<Quantile, Long> getOneMinuteQuantiles() {
        return this.getQuantiles(this.oneMinute);
    }

    public Map<Quantile, Long> getTenMinuteQuantiles() {
        return this.getQuantiles(this.tenMinutes);
    }

    public Map<Quantile, Long> getOneHourQuantiles() {
        return this.getQuantiles(this.oneHour);
    }

    public Map<Quantile, Long> getAllTimeQuantiles() {
        return this.getQuantiles(this.allTime);
    }

    private Map<Quantile, Long> getQuantiles(QuantileDigest digest) {
        ImmutableList keys = ImmutableList.of((Object)((Object)Quantile.P50), (Object)((Object)Quantile.P75), (Object)((Object)Quantile.P95), (Object)((Object)Quantile.P99));
        List<Long> values = digest.getQuantiles(Lists.transform((List)keys, Quantile.getQuantileFunction()));
        Iterator keyIterator = keys.iterator();
        Iterator<Long> valueIterator = values.iterator();
        EnumMap<Quantile, Long> result = new EnumMap<Quantile, Long>(Quantile.class);
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            result.put((Quantile)((Enum)keyIterator.next()), valueIterator.next());
        }
        return result;
    }

    public static enum Quantile {
        P50("p50", 0.5),
        P75("p75", 0.75),
        P95("p95", 0.95),
        P99("p99", 0.99);

        private final String key;
        private final double quantile;

        private Quantile(String key, double quantile) {
            this.key = key;
            this.quantile = quantile;
        }

        public String getKey() {
            return this.key;
        }

        public double getQuantile() {
            return this.quantile;
        }

        public static Function<Quantile, Double> getQuantileFunction() {
            return new Function<Quantile, Double>(){

                public Double apply(Quantile input) {
                    return input.getQuantile();
                }
            };
        }
    }
}

