/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.CompositeMax;
import com.facebook.stats.EventCounter;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.MaxEventCounter;
import com.facebook.stats.ReadableMultiWindowCounter;
import com.facebook.stats.WritableMultiWindowStat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;

public class MultiWindowMax
implements ReadableMultiWindowCounter,
WritableMultiWindowStat {
    private static final ReadableDuration COUNTER_GRANULARITY = Duration.standardSeconds((long)6L);
    private final Object rollLock = new Object();
    private final CompositeMax allTimeCounter;
    private final CompositeMax hourCounter;
    private final CompositeMax tenMinuteCounter;
    private final CompositeMax minuteCounter;
    private volatile EventCounterIf<EventCounter> currentCounter;

    MultiWindowMax(CompositeMax allTimeCounter, CompositeMax hourCounter, CompositeMax tenMinuteCounter, CompositeMax minuteCounter) {
        this.allTimeCounter = allTimeCounter;
        this.hourCounter = hourCounter;
        this.tenMinuteCounter = tenMinuteCounter;
        this.minuteCounter = minuteCounter;
        this.currentCounter = this.addNewCurrentCounter();
    }

    public MultiWindowMax() {
        this(new CompositeMax((ReadableDuration)Duration.standardMinutes((long)Integer.MAX_VALUE)), new CompositeMax((ReadableDuration)Duration.standardMinutes((long)60L)), new CompositeMax((ReadableDuration)Duration.standardMinutes((long)10L)), new CompositeMax((ReadableDuration)Duration.standardMinutes((long)1L)));
    }

    @Override
    public void add(long value) {
        this.rollCurrentIfNeeded();
        this.currentCounter.add(value);
    }

    @Override
    public long getMinuteValue() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getValue();
    }

    @Override
    public long getTenMinuteValue() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getValue();
    }

    @Override
    public long getHourValue() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getValue();
    }

    @Override
    public long getAllTimeValue() {
        this.rollCurrentIfNeeded();
        return this.allTimeCounter.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentIfNeeded() {
        long now = DateTimeUtils.currentTimeMillis();
        if (this.currentCounter.getEnd().getMillis() < now) {
            Object object = this.rollLock;
            synchronized (object) {
                if (this.currentCounter.getEnd().getMillis() < now) {
                    this.currentCounter = this.addNewCurrentCounter();
                }
            }
        }
    }

    private MaxEventCounter addNewCurrentCounter() {
        DateTime now = new DateTime();
        MaxEventCounter maxEventCounter = new MaxEventCounter((ReadableDateTime)now, (ReadableDateTime)now.toDateTime().plus(COUNTER_GRANULARITY));
        this.allTimeCounter.addEventCounter(maxEventCounter);
        this.hourCounter.addEventCounter(maxEventCounter);
        this.tenMinuteCounter.addEventCounter(maxEventCounter);
        this.minuteCounter.addEventCounter(maxEventCounter);
        return maxEventCounter;
    }

    public MultiWindowMax merge(MultiWindowMax other) {
        return new MultiWindowMax((CompositeMax)this.allTimeCounter.merge(other.allTimeCounter), (CompositeMax)this.hourCounter.merge(other.hourCounter), (CompositeMax)this.tenMinuteCounter.merge(other.tenMinuteCounter), (CompositeMax)this.minuteCounter.merge(other.minuteCounter));
    }
}

