/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.CompositeMin;
import com.facebook.stats.EventCounter;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.MinEventCounter;
import com.facebook.stats.ReadableMultiWindowCounter;
import com.facebook.stats.WritableMultiWindowStat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;

public class MultiWindowMin
implements ReadableMultiWindowCounter,
WritableMultiWindowStat {
    private static final ReadableDuration COUNTER_GRANULARITY = Duration.standardSeconds((long)6L);
    private final Object rollLock = new Object();
    private final CompositeMin allTimeCounter;
    private final CompositeMin hourCounter;
    private final CompositeMin tenMinuteCounter;
    private final CompositeMin minuteCounter;
    private volatile EventCounterIf<EventCounter> currentCounter;

    MultiWindowMin(CompositeMin allTimeCounter, CompositeMin hourCounter, CompositeMin tenMinuteCounter, CompositeMin minuteCounter) {
        this.allTimeCounter = allTimeCounter;
        this.hourCounter = hourCounter;
        this.tenMinuteCounter = tenMinuteCounter;
        this.minuteCounter = minuteCounter;
        this.currentCounter = this.addNewCurrentCounter();
    }

    public MultiWindowMin() {
        this(new CompositeMin((ReadableDuration)Duration.standardMinutes((long)Integer.MAX_VALUE)), new CompositeMin((ReadableDuration)Duration.standardMinutes((long)60L)), new CompositeMin((ReadableDuration)Duration.standardMinutes((long)10L)), new CompositeMin((ReadableDuration)Duration.standardMinutes((long)1L)));
    }

    @Override
    public void add(long value) {
        this.rollCurrentIfNeeded();
        this.currentCounter.add(value);
    }

    @Override
    public long getMinuteValue() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getValue();
    }

    @Override
    public long getTenMinuteValue() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getValue();
    }

    @Override
    public long getHourValue() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getValue();
    }

    @Override
    public long getAllTimeValue() {
        this.rollCurrentIfNeeded();
        return this.allTimeCounter.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentIfNeeded() {
        long now = DateTimeUtils.currentTimeMillis();
        if (this.currentCounter.getEnd().getMillis() < now) {
            Object object = this.rollLock;
            synchronized (object) {
                if (this.currentCounter.getEnd().getMillis() < now) {
                    this.currentCounter = this.addNewCurrentCounter();
                }
            }
        }
    }

    private MinEventCounter addNewCurrentCounter() {
        DateTime now = new DateTime();
        MinEventCounter minEventCounter = new MinEventCounter((ReadableDateTime)now, (ReadableDateTime)now.toDateTime().plus(COUNTER_GRANULARITY));
        this.allTimeCounter.addEventCounter(minEventCounter);
        this.hourCounter.addEventCounter(minEventCounter);
        this.tenMinuteCounter.addEventCounter(minEventCounter);
        this.minuteCounter.addEventCounter(minEventCounter);
        return minEventCounter;
    }

    public MultiWindowMin merge(MultiWindowMin other) {
        return new MultiWindowMin((CompositeMin)this.allTimeCounter.merge(other.allTimeCounter), (CompositeMin)this.hourCounter.merge(other.hourCounter), (CompositeMin)this.tenMinuteCounter.merge(other.tenMinuteCounter), (CompositeMin)this.minuteCounter.merge(other.minuteCounter));
    }
}

