/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.facebook.stats.HistoryManager;
import com.facebook.stats.MultiWindowGauge;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StatsManager
implements HistoryManager {
    private static Logger logger = LoggerImpl.getLogger(StatsManager.class);
    private ConcurrentHashMap<String, Integer> typeMap;
    private ConcurrentHashMap<String, MultiWindowGauge> counterMap;

    public StatsManager() {
        this(16, 0.75f, 16);
    }

    public StatsManager(int initialNumKeys, float loadFactor, int concurrencyLevel) {
        logger.trace("StatsMgr Created", new Object[0]);
        this.typeMap = new ConcurrentHashMap(initialNumKeys, loadFactor, concurrencyLevel);
        this.counterMap = new ConcurrentHashMap(initialNumKeys, loadFactor, concurrencyLevel);
    }

    private void ensureStat(String shortName) {
        if (this.counterMap.containsKey(shortName)) {
            return;
        }
        MultiWindowGauge mwg = new MultiWindowGauge();
        MultiWindowGauge wasGauge = this.counterMap.putIfAbsent(shortName, mwg);
        if (wasGauge == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Created stat " + shortName, new Object[0]);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("almost accidentally created stat" + shortName + " twice.  phew...", new Object[0]);
        }
    }

    private void ensureType(String shortName, HistoryManager.ExportType etype) {
        Integer newValue;
        Integer prior;
        boolean hasType = this.typeMap.containsKey(shortName);
        if (!hasType && (prior = this.typeMap.putIfAbsent(shortName, etype.value())) == null) {
            return;
        }
        Integer bitmask = HistoryManager.ExportType.NONE.value();
        int tries = 0;
        while ((bitmask = this.typeMap.get(shortName)) != (newValue = Integer.valueOf(bitmask | etype.value()))) {
            boolean done = this.typeMap.replace(shortName, bitmask, newValue);
            ++tries;
            if (!done) continue;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Updated type for " + shortName + ", added " + (Object)((Object)etype) + ", was " + bitmask + ", now " + newValue + " (after " + tries + " tries)", new Object[0]);
        }
    }

    @Override
    public void addStatExportType(String shortName, HistoryManager.ExportType etype) {
        if (shortName == null) {
            logger.error("Null value passed as key", new Object[0]);
            return;
        }
        if (etype == null) {
            logger.error("Null value passed as exportType", new Object[0]);
            return;
        }
        this.ensureStat(shortName);
        this.ensureType(shortName, etype);
    }

    @Override
    public void addStatValue(String shortName, long delta) {
        if (!this.counterMap.containsKey(shortName)) {
            this.addStatExportType(shortName, HistoryManager.ExportType.AVG);
        }
        MultiWindowGauge stat = this.counterMap.get(shortName);
        stat.add(delta);
    }

    public long getCounter(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot <= 0) {
            throw new IllegalArgumentException("Stat name argument '" + fullName + "' not found");
        }
        int preLastDot = -1;
        String shortName = null;
        String ending = null;
        String ending2 = null;
        preLastDot = fullName.lastIndexOf(46, lastDot - 1);
        ending = fullName.substring(lastDot);
        if (preLastDot > 0) {
            shortName = fullName.substring(0, preLastDot);
            ending2 = fullName.substring(preLastDot);
        } else {
            shortName = fullName.substring(0, lastDot);
        }
        try {
            if (ending.equals(".60")) {
                if (ending2.equals(".sum.60")) {
                    return this.counterMap.get(shortName).getMinuteSum();
                }
                if (ending2.equals(".avg.60")) {
                    return this.counterMap.get(shortName).getMinuteAvg();
                }
                if (ending2.equals(".rate.60")) {
                    return this.counterMap.get(shortName).getMinuteRate();
                }
                if (ending2.equals(".count.60")) {
                    return this.counterMap.get(shortName).getMinuteSamples();
                }
            }
            if (ending.equals(".600")) {
                if (ending2.equals(".sum.600")) {
                    return this.counterMap.get(shortName).getTenMinuteSum();
                }
                if (ending2.equals(".avg.600")) {
                    return this.counterMap.get(shortName).getTenMinuteAvg();
                }
                if (ending2.equals(".rate.600")) {
                    return this.counterMap.get(shortName).getTenMinuteRate();
                }
                if (ending2.equals(".count.600")) {
                    return this.counterMap.get(shortName).getTenMinuteSamples();
                }
            }
            if (ending.equals(".3600")) {
                if (ending2.equals(".sum.3600")) {
                    return this.counterMap.get(shortName).getHourSum();
                }
                if (ending2.equals(".avg.3600")) {
                    return this.counterMap.get(shortName).getHourAvg();
                }
                if (ending2.equals(".rate.3600")) {
                    return this.counterMap.get(shortName).getHourRate();
                }
                if (ending2.equals(".count.3600")) {
                    return this.counterMap.get(shortName).getHourSamples();
                }
            }
            if (fullName.endsWith(".sum")) {
                return this.counterMap.get(shortName).getAllTimeSum();
            }
            if (fullName.endsWith(".avg")) {
                return this.counterMap.get(shortName).getAllTimeAvg();
            }
            if (fullName.endsWith(".rate")) {
                return this.counterMap.get(shortName).getAllTimeRate();
            }
            if (fullName.endsWith(".count")) {
                return this.counterMap.get(shortName).getAllTimeSamples();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Stat name '" + shortName + "' not found for '" + ending2 + "' or '" + ending + "'");
        }
        throw new IllegalArgumentException("Stat name argument '" + fullName + "' not found");
    }

    public Map<String, Long> getSelectedCounters(List<String> keys) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String key : keys) {
            try {
                result.put(key, this.getCounter(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result;
    }

    public boolean hasCounter(String fullName) {
        try {
            this.getCounter(fullName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean containsKey(String shortName) {
        return this.counterMap.containsKey(shortName);
    }

    public Map<String, Long> getCounters() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        Set typeKeys = this.typeMap.keySet();
        for (String name : typeKeys) {
            int bitmask = this.typeMap.get(name);
            MultiWindowGauge stat = this.counterMap.get(name);
            for (HistoryManager.ExportType type : HistoryManager.ExportType.values()) {
                long value;
                if ((bitmask & type.value()) == 0) continue;
                String fullname = String.format("%s.%s.60", new Object[]{name, type});
                switch (type) {
                    case SUM: {
                        value = stat.getMinuteSum();
                        break;
                    }
                    case COUNT: {
                        value = stat.getMinuteSamples();
                        break;
                    }
                    case AVG: {
                        value = stat.getMinuteAvg();
                        break;
                    }
                    case RATE: {
                        value = stat.getMinuteRate();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException("Bad type");
                    }
                }
                result.put(fullname, value);
                fullname = String.format("%s.%s.600", new Object[]{name, type});
                switch (type) {
                    case SUM: {
                        value = stat.getTenMinuteSum();
                        break;
                    }
                    case COUNT: {
                        value = stat.getTenMinuteSamples();
                        break;
                    }
                    case AVG: {
                        value = stat.getTenMinuteAvg();
                        break;
                    }
                    case RATE: {
                        value = stat.getTenMinuteRate();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException("Bad type");
                    }
                }
                result.put(fullname, value);
                fullname = String.format("%s.%s.3600", new Object[]{name, type});
                switch (type) {
                    case SUM: {
                        value = stat.getHourSum();
                        break;
                    }
                    case COUNT: {
                        value = stat.getHourSamples();
                        break;
                    }
                    case AVG: {
                        value = stat.getHourAvg();
                        break;
                    }
                    case RATE: {
                        value = stat.getHourRate();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException("Bad type");
                    }
                }
                result.put(fullname, value);
                fullname = String.format("%s.%s", new Object[]{name, type});
                switch (type) {
                    case SUM: {
                        value = stat.getAllTimeSum();
                        break;
                    }
                    case COUNT: {
                        value = stat.getAllTimeSamples();
                        break;
                    }
                    case AVG: {
                        value = stat.getAllTimeAvg();
                        break;
                    }
                    case RATE: {
                        value = stat.getAllTimeRate();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException("Bad type");
                    }
                }
                result.put(fullname, value);
            }
        }
        return result;
    }
}

