/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.BucketAndHash;
import com.facebook.stats.cardinality.DenseEstimator;
import com.facebook.stats.cardinality.Estimator;
import com.facebook.stats.cardinality.HyperLogLogUtil;
import com.facebook.stats.cardinality.Numbers;
import com.facebook.stats.cardinality.SparseEstimator;
import com.facebook.stats.cardinality.UnsafeUtil;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AdaptiveHyperLogLog {
    private static final int INSTANCE_SIZE = UnsafeUtil.sizeOf(AdaptiveHyperLogLog.class);
    private Estimator estimator;

    public AdaptiveHyperLogLog(int numberOfBuckets) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(numberOfBuckets), (Object)"numberOfBuckets must be a power of 2");
        this.estimator = new SparseEstimator(numberOfBuckets);
    }

    public AdaptiveHyperLogLog(int[] buckets) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(buckets.length), (Object)"numberOfBuckets must be a power of 2");
        this.estimator = AdaptiveHyperLogLog.makeEstimator(buckets);
    }

    public boolean add(long value) {
        BucketAndHash bucketAndHash = BucketAndHash.fromHash(HyperLogLogUtil.computeHash(value), this.estimator.getNumberOfBuckets());
        int lowestBitPosition = Long.numberOfTrailingZeros(bucketAndHash.getHash()) + 1;
        if (this.estimator.getClass() == SparseEstimator.class && (this.estimator.estimateSizeInBytes() >= DenseEstimator.estimateSizeInBytes(this.estimator.getNumberOfBuckets()) || lowestBitPosition >= 16)) {
            this.estimator = new DenseEstimator(this.estimator.buckets());
        }
        return this.estimator.setIfGreater(bucketAndHash.getBucket(), lowestBitPosition);
    }

    public long estimate() {
        return this.estimator.estimate();
    }

    public int getSizeInBytes() {
        return this.estimator.estimateSizeInBytes() + INSTANCE_SIZE;
    }

    public int getNumberOfBuckets() {
        return this.estimator.getNumberOfBuckets();
    }

    public int[] buckets() {
        return this.estimator.buckets();
    }

    public void merge(AdaptiveHyperLogLog other) {
        this.estimator = AdaptiveHyperLogLog.makeEstimator(HyperLogLogUtil.mergeBuckets(this.buckets(), other.buckets()));
    }

    public static AdaptiveHyperLogLog merge(AdaptiveHyperLogLog first, AdaptiveHyperLogLog second) {
        return new AdaptiveHyperLogLog(HyperLogLogUtil.mergeBuckets(first.buckets(), second.buckets()));
    }

    private static Estimator makeEstimator(int[] buckets) {
        int nonZeroBuckets = 0;
        int maxValue = 0;
        for (int value : buckets) {
            maxValue = Math.max(maxValue, value);
            if (value <= 0) continue;
            ++nonZeroBuckets;
        }
        if (maxValue < 16 && SparseEstimator.estimateSizeInBytes(nonZeroBuckets, buckets.length) < DenseEstimator.estimateSizeInBytes(buckets.length)) {
            return new SparseEstimator(buckets);
        }
        return new DenseEstimator(buckets);
    }
}

