/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.cardinality;

import com.facebook.stats.cardinality.Numbers;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Random;

public class HyperLogLogUtil {
    private static final HashFunction HASH = Hashing.murmur3_128();

    public static long estimateCardinality(int[] bucketValues) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(bucketValues.length), (Object)"number of buckets must be a power of 2");
        int zeroBuckets = 0;
        double sum = 0.0;
        int[] nArray = bucketValues;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer value = nArray[i];
            sum += 1.0 / (double)(1L << value);
            if (value != 0) continue;
            ++zeroBuckets;
        }
        double alpha = HyperLogLogUtil.computeAlpha(bucketValues.length);
        double result = alpha * (double)bucketValues.length * (double)bucketValues.length / sum;
        if (result <= 2.5 * (double)bucketValues.length && zeroBuckets > 0) {
            result = (double)bucketValues.length * Math.log((double)bucketValues.length * 1.0 / (double)zeroBuckets);
        }
        return Math.round(result);
    }

    public static int[] generateBuckets(int numberOfBuckets, long cardinality) {
        Preconditions.checkArgument((boolean)Numbers.isPowerOf2(numberOfBuckets), (Object)"number of buckets must be a power of 2");
        double[] probabilities = HyperLogLogUtil.computeProbabilities(numberOfBuckets, cardinality, 127);
        Random random = new Random();
        int[] result = new int[numberOfBuckets];
        for (int i = 0; i < numberOfBuckets; ++i) {
            double trial = random.nextDouble();
            int k = 0;
            while (trial > probabilities[k]) {
                ++k;
            }
            result[i] = k;
        }
        return result;
    }

    private static double cumulativeProbability(int numberOfBuckets, long cardinality, int k) {
        return Math.pow(1.0 - 1.0 / ((double)(1L << k) * 1.0 * (double)numberOfBuckets), cardinality);
    }

    private static double[] computeProbabilities(int numberOfBuckets, long cardinality, int maxK) {
        double[] result = new double[maxK];
        for (int k = 0; k < maxK; ++k) {
            result[k] = HyperLogLogUtil.cumulativeProbability(numberOfBuckets, cardinality, k);
        }
        return result;
    }

    public static int[] mergeBuckets(int[] first, int[] second) {
        Preconditions.checkNotNull((Object)first, (Object)"first is null");
        Preconditions.checkNotNull((Object)second, (Object)"second is null");
        Preconditions.checkArgument((first.length == second.length ? 1 : 0) != 0, (String)"Array sizes must match, found %s vs %s", (Object[])new Object[]{first.length, second.length});
        int[] result = new int[first.length];
        for (int i = 0; i < first.length; ++i) {
            result[i] = Math.max(first[i], second[i]);
        }
        return result;
    }

    public static double computeAlpha(int numberOfBuckets) {
        double alpha;
        switch (numberOfBuckets) {
            case 16: {
                alpha = 0.673;
                break;
            }
            case 32: {
                alpha = 0.697;
                break;
            }
            case 64: {
                alpha = 0.709;
                break;
            }
            default: {
                alpha = 0.7213 / (1.0 + 1.079 / (double)numberOfBuckets);
            }
        }
        return alpha;
    }

    public static long computeHash(long value) {
        return HASH.hashLong(value).asLong();
    }
}

