/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.mx;

import com.facebook.stats.mx.Stats;
import com.google.common.collect.ImmutableSet;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class JVMStatsExporter {
    private final Stats stats;
    private final Pattern statNamePattern;
    private static final String NAME_PREFIX = "jvm";
    private static final Set<? extends OpenType> NUMERIC_TYPES = new ImmutableSet.Builder().add(SimpleType.BYTE).add(SimpleType.SHORT).add(SimpleType.INTEGER).add(SimpleType.LONG).add(SimpleType.FLOAT).add(SimpleType.DOUBLE).build();

    public JVMStatsExporter(Stats stats, String statNamePattern, String ... beanNamePatterns) throws JMException {
        this.stats = stats;
        this.statNamePattern = Pattern.compile(statNamePattern);
        for (String beanNamePattern : beanNamePatterns) {
            this.exportNumericAttributes(new ObjectName(beanNamePattern));
        }
    }

    public JVMStatsExporter(Stats stats) throws JMException {
        this(stats, ".*", "java.lang:type=*,*");
    }

    public static Stats createAndBindTo(Stats stats) throws JMException {
        new JVMStatsExporter(stats);
        return stats;
    }

    public void exportNumericAttributes(ObjectName beanNamePattern) throws JMException {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> beanNames = beanServer.queryNames(beanNamePattern, null);
        for (ObjectName beanName : beanNames) {
            MBeanInfo beanInfo = beanServer.getMBeanInfo(beanName);
            for (MBeanAttributeInfo attributeInfo : beanInfo.getAttributes()) {
                if (!attributeInfo.isReadable()) continue;
                OpenType openType = null;
                if (attributeInfo instanceof OpenMBeanAttributeInfo) {
                    openType = ((OpenMBeanAttributeInfo)((Object)attributeInfo)).getOpenType();
                } else {
                    Object obj = attributeInfo.getDescriptor().getFieldValue("openType");
                    if (obj != null && obj instanceof OpenType) {
                        openType = (OpenType)obj;
                    }
                }
                if (openType == null) continue;
                if (NUMERIC_TYPES.contains(openType)) {
                    this.addStatIfMatches(JVMStatsExporter.getStatName(beanName, attributeInfo.getName()), new MBeanLongAttributeFetcher(beanServer, beanName, attributeInfo.getName()));
                    continue;
                }
                if (!(openType instanceof CompositeType)) continue;
                CompositeType compositeType = (CompositeType)openType;
                for (String key : compositeType.keySet()) {
                    if (!NUMERIC_TYPES.contains(compositeType.getType(key))) continue;
                    this.addStatIfMatches(JVMStatsExporter.getStatName(beanName, attributeInfo.getName(), key), new MBeanLongCompositeValueFetcher(beanServer, beanName, attributeInfo.getName(), key));
                }
            }
        }
    }

    private void addStatIfMatches(String statName, Callable<Long> fetcher) {
        if (this.statNamePattern.matcher(statName).matches()) {
            this.stats.addDynamicCounter(statName, fetcher);
        }
    }

    private static String getStatName(ObjectName beanName, String ... attributeNames) {
        StringBuilder builder = new StringBuilder(NAME_PREFIX);
        String value = beanName.getKeyProperty("type");
        if (value != null) {
            builder.append('.').append(value);
        }
        if ((value = beanName.getKeyProperty("name")) != null) {
            builder.append('.').append(value);
        }
        for (String attributeName : attributeNames) {
            builder.append('.').append(attributeName);
        }
        return builder.toString().replace(' ', '_');
    }

    private static class MBeanLongCompositeValueFetcher
    extends MBeanAttributeFetcher
    implements Callable<Long> {
        private final String itemName;

        private MBeanLongCompositeValueFetcher(MBeanServer mBeanServer, ObjectName beanName, String attribute, String itemName) {
            super(mBeanServer, beanName, attribute);
            this.itemName = itemName;
        }

        @Override
        public Long call() throws Exception {
            Object obj = this.getAttributeValue();
            if (obj instanceof CompositeData && (obj = ((CompositeData)obj).get(this.itemName)) instanceof Number) {
                return ((Number)obj).longValue();
            }
            return -1L;
        }
    }

    private static class MBeanLongAttributeFetcher
    extends MBeanAttributeFetcher
    implements Callable<Long> {
        private MBeanLongAttributeFetcher(MBeanServer mBeanServer, ObjectName beanName, String attribute) {
            super(mBeanServer, beanName, attribute);
        }

        @Override
        public Long call() throws Exception {
            Object obj = this.getAttributeValue();
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            return -1L;
        }
    }

    private static class MBeanAttributeFetcher {
        private final MBeanServer mBeanServer;
        private final ObjectName beanName;
        private final String attribute;

        protected MBeanAttributeFetcher(MBeanServer mBeanServer, ObjectName beanName, String attribute) {
            this.mBeanServer = mBeanServer;
            this.beanName = beanName;
            this.attribute = attribute;
        }

        protected Object getAttributeValue() throws Exception {
            return this.mBeanServer.getAttribute(this.beanName, this.attribute);
        }
    }
}

