/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.mx;

import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.facebook.stats.MultiWindowDistribution;
import com.facebook.stats.MultiWindowRate;
import com.facebook.stats.MultiWindowSpread;
import com.facebook.stats.ReadableMultiWindowRate;
import com.facebook.stats.mx.StatType;
import com.facebook.stats.mx.StatsCollector;
import com.facebook.stats.mx.StatsReader;
import com.facebook.stats.mx.StatsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class Stats
implements StatsReader,
StatsCollector {
    private static final Logger LOG = LoggerImpl.getClassLogger();
    private static final String ERROR_FLAG = "--ERROR--";
    private static final long ERROR_VALUE = -1L;
    private final String prefix;
    private final ConcurrentMap<String, Callable<String>> attributes = new ConcurrentHashMap<String, Callable<String>>();
    private final ConcurrentMap<String, MultiWindowRate> rates = new ConcurrentHashMap<String, MultiWindowRate>();
    private final ConcurrentMap<String, MultiWindowRate> sums = new ConcurrentHashMap<String, MultiWindowRate>();
    private final ConcurrentMap<String, LongCounter> counters = new ConcurrentHashMap<String, LongCounter>();
    private final ConcurrentMap<String, MultiWindowSpread> spreads = new ConcurrentHashMap<String, MultiWindowSpread>();
    private final ConcurrentMap<String, MultiWindowDistribution> distributions = new ConcurrentHashMap<String, MultiWindowDistribution>();

    public Stats(String prefix) {
        this.prefix = prefix;
    }

    public Stats() {
        this("");
    }

    private MultiWindowRate getMultiWindowRate(String key, ConcurrentMap<String, MultiWindowRate> map) {
        MultiWindowRate existingRate;
        MultiWindowRate rate = (MultiWindowRate)map.get(key);
        if (rate == null && (existingRate = map.putIfAbsent(key, rate = new MultiWindowRate())) != null) {
            rate = existingRate;
        }
        return rate;
    }

    @Override
    public void exportCounters(Map<String, Long> counterMap) {
        for (Map.Entry entry : this.rates.entrySet()) {
            StatsUtil.addRateAndSumToCounters(this.prefix + (String)entry.getKey(), (ReadableMultiWindowRate)entry.getValue(), counterMap);
        }
        for (Map.Entry entry : this.sums.entrySet()) {
            StatsUtil.addSumToCounters(this.prefix + (String)entry.getKey(), (ReadableMultiWindowRate)entry.getValue(), counterMap);
        }
        for (Map.Entry entry : this.spreads.entrySet()) {
            StatsUtil.addSpreadToCounters(this.prefix + (String)entry.getKey(), (MultiWindowSpread)entry.getValue(), counterMap);
        }
        for (Map.Entry entry : this.distributions.entrySet()) {
            StatsUtil.addQuantileToCounters(this.prefix + (String)entry.getKey(), (MultiWindowDistribution)entry.getValue(), counterMap);
        }
        Long duplicate = null;
        for (Map.Entry entry : this.counters.entrySet()) {
            duplicate = counterMap.put(this.prefix + (String)entry.getKey(), ((LongCounter)entry.getValue()).get());
            if (duplicate == null) continue;
            LOG.warn("Duplicate counter(3) : %s, Ignoring old value %s", new Object[]{this.prefix + (String)entry.getKey(), duplicate});
        }
    }

    @Override
    public MultiWindowRate getRate(StatType statType) {
        return this.getRate(statType.getKey());
    }

    @Override
    public MultiWindowRate getRate(String key) {
        return this.getMultiWindowRate(key, this.rates);
    }

    @Override
    public void incrementRate(StatType type, long delta) {
        this.getMultiWindowRate(type.getKey(), this.rates).add(delta);
    }

    @Override
    public void incrementRate(String key, long delta) {
        this.getMultiWindowRate(key, this.rates).add(delta);
    }

    @Override
    public MultiWindowRate getSum(StatType statType) {
        return this.getSum(statType.getKey());
    }

    @Override
    public MultiWindowRate getSum(String key) {
        return this.getMultiWindowRate(key, this.sums);
    }

    @Override
    public void incrementSum(StatType type, long delta) {
        this.getMultiWindowRate(type.getKey(), this.sums).add(delta);
    }

    @Override
    public void incrementSum(String key, long delta) {
        this.getMultiWindowRate(key, this.sums).add(delta);
    }

    @Override
    public void incrementCounter(StatType key, long delta) {
        this.internalIncrementCounter(key.getKey(), delta);
    }

    @Override
    public void incrementCounter(String key, long delta) {
        this.internalIncrementCounter(key, delta);
    }

    private void internalIncrementCounter(String key, long delta) {
        LongCounter existingCounter;
        LongCounter counter = (LongCounter)this.counters.get(key);
        if (counter == null && (existingCounter = this.counters.putIfAbsent(key, counter = new AtomicLongCounter())) != null) {
            counter = existingCounter;
        }
        counter.update(delta);
    }

    @Override
    @Deprecated
    public long setCounter(StatType statType, long value) {
        return StatsUtil.setCounterValue(statType.getKey(), value, (StatsCollector)this);
    }

    @Override
    @Deprecated
    public long setCounter(String key, long value) {
        return StatsUtil.setCounterValue(key, value, (StatsCollector)this);
    }

    @Override
    public long resetCounter(StatType key) {
        return this.internalResetCounter(key.getKey());
    }

    @Override
    public long resetCounter(String key) {
        return this.internalResetCounter(key);
    }

    private long internalResetCounter(String key) {
        LongCounter counter = (LongCounter)this.counters.remove(key);
        return counter == null ? 0L : counter.get();
    }

    @Override
    public void incrementSpread(StatType type, long value) {
        this.getMultiWindowSpread(type.getKey()).add(value);
    }

    @Override
    public void incrementSpread(String key, long value) {
        this.getMultiWindowSpread(key).add(value);
    }

    @Override
    public void updateDistribution(StatType type, long value) {
        this.getMultiWindowDistribution(type.getKey()).add(value);
    }

    @Override
    public void updateDistribution(String key, long value) {
        this.getMultiWindowDistribution(key).add(value);
    }

    @Override
    public long getCounter(StatType key) {
        return this.internalGetCounter(key.getKey());
    }

    @Override
    public long getCounter(String key) {
        return this.internalGetCounter(key);
    }

    @Override
    public MultiWindowSpread getSpread(StatType key) {
        return this.getMultiWindowSpread(key.getKey());
    }

    @Override
    public MultiWindowSpread getSpread(String key) {
        return this.getMultiWindowSpread(key);
    }

    @Override
    public MultiWindowDistribution getDistribution(StatType key) {
        return this.getMultiWindowDistribution(key.getKey());
    }

    @Override
    public MultiWindowDistribution getDistribution(String key) {
        return this.getMultiWindowDistribution(key);
    }

    public boolean addDynamicCounter(String key, Callable<Long> valueProducer) {
        return null == this.counters.putIfAbsent(key, new CallableLongCounter(key, valueProducer));
    }

    public boolean removeCounter(String key) {
        return this.counters.remove(key) != null;
    }

    private long internalGetCounter(String key) {
        LongCounter counter = (LongCounter)this.counters.get(key);
        return counter == null ? 0L : counter.get();
    }

    @Override
    public String getAttribute(StatType key) {
        return this.internalGetAttribute(key.getKey());
    }

    @Override
    public void setAttribute(StatType key, String value) {
        this.internalSetAttribute(key.getKey(), new StringProducer(value));
    }

    @Override
    public void setAttribute(String key, String value) {
        this.internalSetAttribute(key, new StringProducer(value));
    }

    @Override
    public void setAttribute(StatType key, Callable<String> valueProducer) {
        this.internalSetAttribute(key.getKey(), valueProducer);
    }

    @Override
    public void setAttribute(String key, Callable<String> valueProducer) {
        this.internalSetAttribute(key, valueProducer);
    }

    public boolean removeAttribute(String key) {
        return this.attributes.remove(key) != null;
    }

    private void internalSetAttribute(String key, Callable<String> valueProducer) {
        try {
            this.attributes.put(key, valueProducer);
        }
        catch (Exception e) {
            LOG.error("error in producer for key %s", new Object[]{key, e});
        }
    }

    @Override
    public String getAttribute(String key) {
        return this.internalGetAttribute(key);
    }

    @Override
    @Deprecated
    public Callable<Long> getDynamicCounter(StatType key) {
        final LongCounter longCounter = (LongCounter)this.counters.get(key.getKey());
        return new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return longCounter.get();
            }
        };
    }

    @Override
    @Deprecated
    public Callable<Long> getDynamicCounter(String key) {
        final LongCounter longCounter = (LongCounter)this.counters.get(key);
        return new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return longCounter.get();
            }
        };
    }

    private String internalGetAttribute(String key) {
        try {
            Callable callable = (Callable)this.attributes.get(key);
            return callable == null ? null : (String)callable.call();
        }
        catch (Exception e) {
            LOG.error("error producing value for key %s", new Object[]{key, e});
            return ERROR_FLAG;
        }
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.materializeAttributes();
    }

    private Map<String, String> materializeAttributes() {
        HashMap<String, String> materializedAttributes = new HashMap<String, String>();
        for (Map.Entry entry : this.attributes.entrySet()) {
            try {
                materializedAttributes.put((String)entry.getKey(), (String)((Callable)entry.getValue()).call());
            }
            catch (Exception e) {
                materializedAttributes.put((String)entry.getKey(), ERROR_FLAG);
                LOG.error("error producing value for key %s", new Object[]{entry.getKey(), e});
            }
        }
        for (Map.Entry entry : this.distributions.entrySet()) {
            StatsUtil.addHistogramToExportedValues((String)entry.getKey(), (MultiWindowDistribution)entry.getValue(), materializedAttributes);
        }
        return materializedAttributes;
    }

    private MultiWindowSpread getMultiWindowSpread(String key) {
        MultiWindowSpread existingSpreads;
        MultiWindowSpread spread = (MultiWindowSpread)this.spreads.get(key);
        if (spread == null && (existingSpreads = this.spreads.putIfAbsent(key, spread = new MultiWindowSpread())) != null) {
            spread = existingSpreads;
        }
        return spread;
    }

    private MultiWindowDistribution getMultiWindowDistribution(String key) {
        MultiWindowDistribution existing;
        MultiWindowDistribution distribution = (MultiWindowDistribution)this.distributions.get(key);
        if (distribution == null && (existing = this.distributions.putIfAbsent(key, distribution = new MultiWindowDistribution())) != null) {
            distribution = existing;
        }
        return distribution;
    }

    private static class CallableLongCounter
    implements LongCounter {
        private final String key;
        private Callable<Long> longCallable;

        private CallableLongCounter(String key, Callable<Long> longCallable) {
            this.key = key;
            this.longCallable = longCallable;
        }

        @Override
        public void update(long delta) {
        }

        @Override
        public long get() {
            try {
                return this.longCallable.call();
            }
            catch (Exception e) {
                LOG.debug("Exception when generating dynamic counter value for %s", new Object[]{this.key, e});
                return -1L;
            }
        }
    }

    private static class AtomicLongCounter
    implements LongCounter {
        private final AtomicLong value = new AtomicLong(0L);

        private AtomicLongCounter() {
        }

        @Override
        public void update(long delta) {
            this.value.addAndGet(delta);
        }

        @Override
        public long get() {
            return this.value.get();
        }
    }

    private static interface LongCounter {
        public void update(long var1);

        public long get();
    }

    private static class StringProducer
    implements Callable<String> {
        private final String value;

        private StringProducer(String value) {
            this.value = value;
        }

        @Override
        public String call() throws Exception {
            return this.value;
        }
    }
}

