/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.mx;

import com.facebook.stats.EventCounterIf;
import com.facebook.stats.MultiWindowDistribution;
import com.facebook.stats.MultiWindowRate;
import com.facebook.stats.MultiWindowSpread;
import com.facebook.stats.QuantileDigest;
import com.facebook.stats.ReadableMultiWindowCounter;
import com.facebook.stats.ReadableMultiWindowGauge;
import com.facebook.stats.ReadableMultiWindowRate;
import com.facebook.stats.mx.StatType;
import com.facebook.stats.mx.StatsCollector;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class StatsUtil {
    @Deprecated
    public static void adddKeyToCounters(String baseKey, ReadableMultiWindowRate rate, Map<String, Long> counterMap) {
        StatsUtil.addRateToCounters(baseKey, rate, counterMap);
        StatsUtil.addSumToCounters(baseKey, rate, counterMap);
    }

    public static void addRateAndSumToCounters(String baseKey, ReadableMultiWindowRate rate, Map<String, Long> counterMap) {
        StatsUtil.addRateToCounters(baseKey, rate, counterMap);
        StatsUtil.addSumToCounters(baseKey, rate, counterMap);
    }

    public static void addRateToCounters(String baseKey, ReadableMultiWindowRate rate, Map<String, Long> counterMap) {
        counterMap.put(baseKey + ".rate", rate.getAllTimeRate());
        counterMap.put(baseKey + ".rate.3600", rate.getHourRate());
        counterMap.put(baseKey + ".rate.600", rate.getTenMinuteRate());
        counterMap.put(baseKey + ".rate.60", rate.getMinuteRate());
    }

    public static void addSumToCounters(String baseKey, ReadableMultiWindowRate rate, Map<String, Long> counterMap) {
        counterMap.put(baseKey + ".sum", rate.getAllTimeSum());
        counterMap.put(baseKey + ".sum.3600", rate.getHourSum());
        counterMap.put(baseKey + ".sum.600", rate.getTenMinuteSum());
        counterMap.put(baseKey + ".sum.60", rate.getMinuteSum());
    }

    public static void addGaugeAvgToCounters(String baseKey, ReadableMultiWindowGauge gauge, Map<String, Long> counterMap) {
        counterMap.put(baseKey + ".avg", gauge.getAllTimeAvg());
        counterMap.put(baseKey + ".avg.3600", gauge.getHourAvg());
        counterMap.put(baseKey + ".avg.600", gauge.getTenMinuteAvg());
        counterMap.put(baseKey + ".avg.60", gauge.getMinuteAvg());
    }

    public static void addGaugeSamplesToCounters(String baseKey, ReadableMultiWindowGauge gauge, Map<String, Long> counterMap) {
        counterMap.put(baseKey + ".samples", gauge.getAllTimeSamples());
        counterMap.put(baseKey + ".samples.3600", gauge.getHourSamples());
        counterMap.put(baseKey + ".samples.600", gauge.getTenMinuteSamples());
        counterMap.put(baseKey + ".samples.60", gauge.getMinuteSamples());
    }

    private static void addValueToCounters(String baseKey, ReadableMultiWindowCounter counter, Map<String, Long> counterMap) {
        counterMap.put(baseKey, counter.getAllTimeValue());
        counterMap.put(baseKey + ".3600", counter.getHourValue());
        counterMap.put(baseKey + ".600", counter.getTenMinuteValue());
        counterMap.put(baseKey + ".60", counter.getMinuteValue());
    }

    public static void addSpreadToCounters(String baseKey, MultiWindowSpread spread, Map<String, Long> counterMap) {
        StatsUtil.addValueToCounters(baseKey + ".min", spread.getMin(), counterMap);
        StatsUtil.addValueToCounters(baseKey + ".max", spread.getMax(), counterMap);
        StatsUtil.addGaugeAvgToCounters(baseKey, spread.getGauge(), counterMap);
        StatsUtil.addGaugeSamplesToCounters(baseKey, spread.getGauge(), counterMap);
    }

    public static void addQuantileToCounters(String baseKey, MultiWindowDistribution quantiles, Map<String, Long> counterMap) {
        StatsUtil.addQuantilesToCounters(baseKey, ".60", counterMap, quantiles.getOneMinuteQuantiles());
        StatsUtil.addQuantilesToCounters(baseKey, ".600", counterMap, quantiles.getTenMinuteQuantiles());
        StatsUtil.addQuantilesToCounters(baseKey, ".3600", counterMap, quantiles.getOneHourQuantiles());
        StatsUtil.addQuantilesToCounters(baseKey, "", counterMap, quantiles.getAllTimeQuantiles());
    }

    public static void addHistogramToExportedValues(String baseKey, MultiWindowDistribution quantiles, Map<String, String> values) {
        StatsUtil.addHistogramToExportedValues(baseKey, ".60", values, quantiles.getOneMinute());
        StatsUtil.addHistogramToExportedValues(baseKey, ".600", values, quantiles.getTenMinutes());
        StatsUtil.addHistogramToExportedValues(baseKey, ".3600", values, quantiles.getOneHour());
        StatsUtil.addHistogramToExportedValues(baseKey, "", values, quantiles.getAllTime());
    }

    private static void addHistogramToExportedValues(String baseKey, String windowKey, Map<String, String> values, QuantileDigest digest) {
        values.put(baseKey + ".hist" + windowKey, StatsUtil.serializeHistogram(digest));
    }

    private static String serializeHistogram(QuantileDigest digest) {
        int buckets = 100;
        long min = digest.getMin();
        long max = digest.getMax();
        long bucketSize = (max - min + (long)buckets) / (long)buckets;
        ImmutableList.Builder boundaryBuilder = ImmutableList.builder();
        for (int i = 1; i < buckets + 1; ++i) {
            boundaryBuilder.add((Object)(min + bucketSize * (long)i));
        }
        ImmutableList boundaries = boundaryBuilder.build();
        List<QuantileDigest.Bucket> counts = digest.getHistogram((List<Long>)boundaries);
        StringBuilder builder = new StringBuilder();
        builder.append("-1:0:0,");
        for (int i = 0; i < boundaries.size(); ++i) {
            long lowBoundary = min;
            if (i > 0) {
                lowBoundary = (Long)boundaries.get(i - 1);
            }
            builder.append(lowBoundary).append(':').append(Math.round(counts.get(i).getCount())).append(':').append(Math.round(counts.get(i).getMean())).append(',');
        }
        builder.append(max);
        builder.append(":0:0");
        return builder.toString();
    }

    private static void addQuantilesToCounters(String baseKey, String windowKey, Map<String, Long> counters, Map<MultiWindowDistribution.Quantile, Long> oneMinuteQuantiles) {
        for (Map.Entry<MultiWindowDistribution.Quantile, Long> entry : oneMinuteQuantiles.entrySet()) {
            counters.put(baseKey + "." + entry.getKey().getKey() + windowKey, entry.getValue());
        }
    }

    public static void setAllTimeSum(MultiWindowRate rate, long value) {
        long old = rate.getAllTimeSum();
        if (old > value) {
            throw new IllegalArgumentException("MultiWindowRate counters can not decrement their allTimeSum (" + old + " > " + value + ")");
        }
        if (old == value) {
            return;
        }
        long delta = value - old;
        rate.add(delta);
    }

    public static Duration extentOf(EventCounterIf counter1, EventCounterIf counter2) {
        ReadableDateTime start = counter1.getStart();
        ReadableDateTime end = counter1.getEnd();
        if (counter2.getStart().isBefore((ReadableInstant)start)) {
            start = counter2.getStart();
        }
        if (counter2.getEnd().isAfter((ReadableInstant)end)) {
            end = counter2.getEnd();
        }
        return new Duration((ReadableInstant)start, (ReadableInstant)end);
    }

    public static long setCounterValue(StatType statType, long value, StatsCollector stats) {
        long oldValue = StatsUtil.setCounterValue(statType.getKey(), value, stats);
        return oldValue;
    }

    public static long setCounterValue(String key, long value, StatsCollector stats) {
        long oldValue = stats.resetCounter(key);
        stats.incrementCounter(key, value);
        return oldValue;
    }
}

