/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.topk;

import com.facebook.stats.topk.TopK;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class ArrayBasedIntegerTopK
implements TopK<Integer> {
    private final int k;
    private final long[] counts;

    public ArrayBasedIntegerTopK(int keySpaceSize, int k) {
        this.k = k;
        this.counts = new long[keySpaceSize];
    }

    @Override
    public synchronized void add(Integer key, long count) {
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Preconditions.checkElementIndex((int)key, (int)this.counts.length, (String)"key");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"count to add must be non-negative, got %s", (Object[])new Object[]{count});
        int n = key;
        this.counts[n] = this.counts[n] + count;
    }

    @Override
    public List<Integer> getTopK() {
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return Longs.compare((long)ArrayBasedIntegerTopK.this.counts[i], (long)ArrayBasedIntegerTopK.this.counts[j]);
            }
        };
        PriorityQueue<Integer> topK = new PriorityQueue<Integer>(this.k, comparator);
        for (int key = 0; key < this.counts.length; ++key) {
            if (topK.size() < this.k) {
                if (this.counts[key] <= 0L) continue;
                topK.offer(key);
                continue;
            }
            if (this.counts[key] <= this.counts[topK.peek()]) continue;
            topK.poll();
            topK.offer(key);
        }
        LinkedList<Integer> sortedTopK = new LinkedList<Integer>();
        while (!topK.isEmpty()) {
            sortedTopK.addFirst(topK.poll());
        }
        return sortedTopK;
    }
}

