/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.topk;

import com.facebook.collections.ComparablePair;
import com.facebook.stats.topk.TopK;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class TreeBasedIntegerTopK
implements TopK<Integer> {
    private final int k;
    private final long[] counts;
    private final boolean[] isInTop;
    private final TreeSet<ComparablePair<Long, Integer>> topPairs = new TreeSet();
    private long smallestTopCount = Long.MAX_VALUE;

    public TreeBasedIntegerTopK(int keySpaceSize, int k) {
        this.k = k;
        this.counts = new long[keySpaceSize];
        this.isInTop = new boolean[keySpaceSize];
    }

    @Override
    public synchronized void add(Integer key, long count) {
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Preconditions.checkElementIndex((int)key, (int)this.counts.length, (String)"key");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"count to add must be non-negative, got %s", (Object[])new Object[]{count});
        if (count == 0L) {
            return;
        }
        long currentCount = this.counts[key];
        int n = key;
        this.counts[n] = this.counts[n] + count;
        if (this.isInTop[key]) {
            this.topPairs.remove(new ComparablePair((Comparable)Long.valueOf(currentCount), (Comparable)key));
            this.topPairs.add((ComparablePair<Long, Integer>)new ComparablePair((Comparable)Long.valueOf(this.counts[key]), (Comparable)key));
        } else if (this.topPairs.size() < this.k) {
            this.topPairs.add((ComparablePair<Long, Integer>)new ComparablePair((Comparable)Long.valueOf(this.counts[key]), (Comparable)key));
            this.isInTop[key.intValue()] = true;
            this.smallestTopCount = Math.min(this.smallestTopCount, this.counts[key]);
        } else if (this.counts[key] > this.smallestTopCount) {
            ComparablePair<Long, Integer> smallestTopPair = this.topPairs.pollFirst();
            this.isInTop[((Integer)smallestTopPair.getSecond()).intValue()] = false;
            this.topPairs.add((ComparablePair<Long, Integer>)new ComparablePair((Comparable)Long.valueOf(this.counts[key]), (Comparable)key));
            this.isInTop[key.intValue()] = true;
            this.smallestTopCount = (Long)this.topPairs.first().getFirst();
        }
    }

    @Override
    public synchronized List<Integer> getTopK() {
        LinkedList<Integer> topK = new LinkedList<Integer>();
        for (ComparablePair<Long, Integer> pair : this.topPairs) {
            topK.addFirst((Integer)pair.getSecond());
        }
        return topK;
    }
}

