/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats.topk;

import com.facebook.collections.ComparablePair;
import com.facebook.stats.topk.TopK;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TreeBasedTopK<T extends Comparable<T>>
implements TopK<T> {
    private final int k;
    private final Map<T, Long> counts = new HashMap<T, Long>();
    private final Set<T> topKeys;
    private final TreeSet<ComparablePair<Long, T>> topPairs = new TreeSet();
    private long smallestTopCount = Long.MAX_VALUE;

    public TreeBasedTopK(int k) {
        this.k = k;
        this.topKeys = new HashSet<T>(k);
    }

    @Override
    public synchronized void add(T key, long count) {
        Preconditions.checkNotNull(key, (Object)"key can't be null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"count to add must be non-negative, got %s", (Object[])new Object[]{count});
        if (count == 0L) {
            return;
        }
        Long currentCount = this.counts.get(key);
        if (currentCount == null) {
            currentCount = 0L;
        }
        long updatedCount = currentCount + count;
        this.counts.put(key, updatedCount);
        if (this.topKeys.contains(key)) {
            this.topPairs.remove(new ComparablePair((Comparable)currentCount, key));
            this.topPairs.add(new ComparablePair((Comparable)Long.valueOf(updatedCount), key));
        } else if (this.topPairs.size() < this.k) {
            this.topPairs.add(new ComparablePair((Comparable)Long.valueOf(updatedCount), key));
            this.topKeys.add(key);
            this.smallestTopCount = Math.min(this.smallestTopCount, updatedCount);
        } else if (updatedCount > this.smallestTopCount) {
            ComparablePair<Long, T> smallestTopPair = this.topPairs.pollFirst();
            this.topKeys.remove(smallestTopPair.getSecond());
            this.topPairs.add(new ComparablePair((Comparable)Long.valueOf(updatedCount), key));
            this.topKeys.add(key);
            this.smallestTopCount = (Long)this.topPairs.first().getFirst();
        }
    }

    @Override
    public synchronized List<T> getTopK() {
        LinkedList<Object> topK = new LinkedList<Object>();
        for (ComparablePair<Long, T> pair : this.topPairs) {
            topK.addFirst(pair.getSecond());
        }
        return topK;
    }
}

