/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.collections.PeekableIterator;
import com.facebook.stats.CompositeEventCounterIf;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.mx.StatsUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public abstract class AbstractCompositeCounter<C extends EventCounterIf<C>>
implements CompositeEventCounterIf<C> {
    @GuardedBy(value="this")
    private final Deque<C> eventCounters = new ArrayDeque<C>();
    private final ReadableDuration maxLength;
    private final ReadableDuration maxChunkLength;
    private ReadableDateTime start;
    private ReadableDateTime end;

    public AbstractCompositeCounter(ReadableDuration maxLength, ReadableDuration maxChunkLength) {
        this.maxLength = maxLength;
        this.maxChunkLength = maxChunkLength;
        DateTime now = new DateTime();
        this.start = now;
        this.end = now;
    }

    public AbstractCompositeCounter(ReadableDuration maxLength) {
        this(maxLength, (ReadableDuration)new Duration(maxLength.getMillis() / 10L));
    }

    @Override
    public abstract C merge(C var1);

    protected abstract C nextCounter(ReadableDateTime var1, ReadableDateTime var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long delta) {
        EventCounterIf last;
        DateTime now = new DateTime();
        AbstractCompositeCounter abstractCompositeCounter = this;
        synchronized (abstractCompositeCounter) {
            if (this.eventCounters.isEmpty() || !now.isBefore((ReadableInstant)((EventCounterIf)this.eventCounters.getLast()).getEnd())) {
                this.addEventCounter(this.nextCounter((ReadableDateTime)now, (ReadableDateTime)now.plus(this.maxChunkLength)));
            }
            last = (EventCounterIf)this.eventCounters.getLast();
        }
        last.add(delta);
    }

    @Override
    public ReadableDateTime getStart() {
        this.trimIfNeeded();
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        this.trimIfNeeded();
        return this.end;
    }

    @Override
    public Duration getLength() {
        this.trimIfNeeded();
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public synchronized CompositeEventCounterIf<C> add(long delta, ReadableDateTime start, ReadableDateTime end) {
        C counter = this.nextCounter(start, end);
        counter.add(delta);
        return this.addEventCounter(counter);
    }

    @Override
    public synchronized CompositeEventCounterIf<C> addEventCounter(C eventCounter) {
        if (this.eventCounters.size() >= 2) {
            this.mergeChunksIfNeeded();
        }
        Preconditions.checkArgument((this.eventCounters.isEmpty() || !((EventCounterIf)this.eventCounters.getLast()).getEnd().isAfter((ReadableInstant)eventCounter.getEnd()) ? 1 : 0) != 0, (String)"new counter end , %s, is not past the current end %s", (Object)eventCounter.getEnd(), (Object)(this.eventCounters.isEmpty() ? "NaN" : ((EventCounterIf)this.eventCounters.getLast()).getEnd()));
        this.eventCounters.add(eventCounter);
        if (eventCounter.getStart().isBefore((ReadableInstant)this.start)) {
            this.start = eventCounter.getStart();
            this.trimIfNeeded();
        }
        if (eventCounter.getEnd().isAfter((ReadableInstant)this.end)) {
            this.end = eventCounter.getEnd();
            this.trimIfNeeded();
        }
        return this;
    }

    private void mergeChunksIfNeeded() {
        EventCounterIf counter2;
        EventCounterIf counter1 = (EventCounterIf)this.eventCounters.removeLast();
        if (StatsUtil.extentOf(counter1, counter2 = (EventCounterIf)this.eventCounters.getLast()).isLongerThan(this.maxChunkLength)) {
            this.eventCounters.add(counter1);
        } else {
            this.eventCounters.removeLast();
            this.eventCounters.add(counter1.merge(counter2));
        }
    }

    protected synchronized <C2 extends CompositeEventCounterIf<C>> C2 internalMerge(Collection<? extends C> otherCounters, C2 mergedCounter) {
        PeekableIterator iter1 = new PeekableIterator(this.eventCounters.iterator());
        PeekableIterator iter2 = new PeekableIterator(otherCounters.iterator());
        while (iter1.hasNext() || iter2.hasNext()) {
            if (iter1.hasNext() && iter2.hasNext()) {
                if (((EventCounterIf)iter1.peekNext()).getStart().isBefore((ReadableInstant)((EventCounterIf)iter2.peekNext()).getStart())) {
                    mergedCounter.addEventCounter((EventCounterIf)((EventCounterIf)iter1.next()));
                    continue;
                }
                mergedCounter.addEventCounter((EventCounterIf)((EventCounterIf)iter2.next()));
                continue;
            }
            if (iter1.hasNext()) {
                mergedCounter.addEventCounter((EventCounterIf)((EventCounterIf)iter1.next()));
                continue;
            }
            if (!iter2.hasNext()) continue;
            mergedCounter.addEventCounter((EventCounterIf)((EventCounterIf)iter2.next()));
        }
        return mergedCounter;
    }

    protected synchronized void trimIfNeeded() {
        Duration delta = new Duration((ReadableInstant)this.start, (ReadableInstant)new DateTime()).minus(this.maxLength);
        if (delta.isLongerThan((ReadableDuration)Duration.ZERO)) {
            EventCounterIf counter;
            this.start = this.start.toDateTime().plus((ReadableDuration)delta);
            if (this.start.isAfter((ReadableInstant)this.end)) {
                this.end = this.start;
            }
            Iterator<C> iter = this.eventCounters.iterator();
            while (iter.hasNext() && !this.start.isBefore((ReadableInstant)(counter = (EventCounterIf)iter.next()).getEnd())) {
                iter.remove();
            }
        }
    }

    protected float getExpiredFraction(EventCounterIf<C> oldestCounter) {
        ReadableDateTime windowStart = this.getWindowStart();
        Preconditions.checkArgument((!oldestCounter.getEnd().isBefore((ReadableInstant)windowStart) ? 1 : 0) != 0, (String)"counter should have end %s >= window start %s", (Object)oldestCounter.getEnd(), (Object)windowStart);
        ReadableDateTime counterStart = oldestCounter.getStart();
        Preconditions.checkArgument((boolean)counterStart.isBefore((ReadableInstant)windowStart), (String)"counter should have start %s <= window start %s", (Object)counterStart, (Object)windowStart);
        long expiredPortionMillis = windowStart.getMillis() - counterStart.getMillis();
        long lengthMillis = oldestCounter.getEnd().getMillis() - counterStart.getMillis();
        float expiredFraction = (float)expiredPortionMillis / (float)lengthMillis;
        Preconditions.checkState((expiredFraction >= 0.0f && (double)expiredFraction <= 1.0 ? 1 : 0) != 0, (String)"%s not in [0, 1]", (Object)Float.valueOf(expiredFraction));
        return expiredFraction;
    }

    @Deprecated
    protected synchronized List<C> getEventCountersCopy() {
        return new ArrayList<C>(this.eventCounters);
    }

    protected synchronized Collection<C> getEventCounters() {
        return Collections.unmodifiableCollection(this.eventCounters);
    }

    protected synchronized C getMostRecentCounter() {
        return (C)((EventCounterIf)this.eventCounters.peekLast());
    }

    protected Iterator<C> eventCounterIterator() {
        return Iterators.unmodifiableIterator(this.eventCounters.iterator());
    }

    protected ReadableDateTime getWindowStart() {
        return this.start;
    }

    protected ReadableDateTime getWindowEnd() {
        return this.end;
    }

    protected ReadableDuration getMaxLength() {
        return this.maxLength;
    }

    protected ReadableDuration getMaxChunkLength() {
        return this.maxChunkLength;
    }
}

