/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.AbstractCompositeCounter;
import com.facebook.stats.EventCounterIf;
import java.util.Iterator;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public abstract class AbstractCompositeSum<C extends EventCounterIf<C>>
extends AbstractCompositeCounter<C> {
    protected AbstractCompositeSum(ReadableDuration maxLength, ReadableDuration maxChunkLength) {
        super(maxLength, maxChunkLength);
    }

    protected AbstractCompositeSum(ReadableDuration maxLength) {
        super(maxLength);
    }

    @Override
    public synchronized long getValue() {
        this.trimIfNeeded();
        long value = 0L;
        Iterator iter = this.getEventCounters().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            EventCounterIf counter = (EventCounterIf)iter.next();
            value += counter.getValue();
            if (!first) continue;
            if (counter.getStart().isBefore((ReadableInstant)this.getWindowStart())) {
                value -= (long)(this.getExpiredFraction(counter) * (float)counter.getValue());
            }
            first = false;
        }
        return value;
    }
}

