/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.AssociativeAggregation;
import com.facebook.stats.EventCounter;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class AssociativeAggregationCounter
implements EventCounter {
    private final ReadableDateTime start;
    private final ReadableDateTime end;
    private final long initialValue;
    private final AssociativeAggregation associativeAggregation;
    protected final AtomicLong value;

    public AssociativeAggregationCounter(ReadableDateTime start, ReadableDateTime end, AssociativeAggregation associativeAggregation, long initialValue) {
        if (start.isAfter((ReadableInstant)end)) {
            this.start = end;
            this.end = start;
        } else {
            this.start = start;
            this.end = end;
        }
        this.initialValue = initialValue;
        this.associativeAggregation = associativeAggregation;
        this.value = new AtomicLong(initialValue);
    }

    @Override
    public void add(long delta) {
        long val = this.value.get();
        while (!this.value.compareAndSet(val, this.associativeAggregation.combine(val, delta))) {
            val = this.value.get();
        }
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public ReadableDateTime getStart() {
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        return this.end;
    }

    @Override
    public Duration getLength() {
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public EventCounter merge(EventCounter counter) {
        ReadableDateTime mergedStart = this.start;
        ReadableDateTime mergedEnd = this.end;
        if (counter.getStart().isBefore((ReadableInstant)mergedStart)) {
            mergedStart = counter.getStart();
        }
        if (counter.getEnd().isAfter((ReadableInstant)mergedEnd)) {
            mergedEnd = counter.getEnd();
        }
        AssociativeAggregationCounter mergedCounter = new AssociativeAggregationCounter(mergedStart, mergedEnd, this.associativeAggregation, this.initialValue);
        mergedCounter.add(this.associativeAggregation.combine(this.value.get(), counter.getValue()));
        return mergedCounter;
    }
}

