/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.AbstractCompositeSum;
import com.facebook.stats.CompositeEventCounterIf;
import com.facebook.stats.DefaultGaugeCounterFactory;
import com.facebook.stats.GaugeCounter;
import com.facebook.stats.GaugeCounterFactory;
import java.util.Arrays;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class CompositeGaugeCounter
extends AbstractCompositeSum<GaugeCounter>
implements GaugeCounter {
    private final GaugeCounterFactory gaugeCounterFactory;

    public CompositeGaugeCounter(ReadableDuration maxLength, ReadableDuration maxChunkLength, GaugeCounterFactory gaugeCounterFactory) {
        super(maxLength, maxChunkLength);
        this.gaugeCounterFactory = gaugeCounterFactory;
    }

    public CompositeGaugeCounter(ReadableDuration maxLength, GaugeCounterFactory gaugeCounterFactory) {
        super(maxLength);
        this.gaugeCounterFactory = gaugeCounterFactory;
    }

    public CompositeGaugeCounter(ReadableDuration maxLength) {
        this(maxLength, DefaultGaugeCounterFactory.INSTANCE);
    }

    public synchronized CompositeEventCounterIf<GaugeCounter> add(long delta, long nsamples, ReadableDateTime start, ReadableDateTime end) {
        GaugeCounter counter = this.nextCounter(start, end);
        counter.add(delta, nsamples);
        return this.addEventCounter(counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long delta, long nsamples) {
        GaugeCounter last;
        DateTime now = new DateTime();
        CompositeGaugeCounter compositeGaugeCounter = this;
        synchronized (compositeGaugeCounter) {
            if (this.getMostRecentCounter() == null || !now.isBefore((ReadableInstant)((GaugeCounter)this.getMostRecentCounter()).getEnd())) {
                this.addEventCounter(this.nextCounter((ReadableDateTime)now, (ReadableDateTime)now.plus(this.getMaxChunkLength())));
            }
            last = (GaugeCounter)this.getMostRecentCounter();
        }
        last.add(delta, nsamples);
    }

    @Override
    public synchronized long getSamples() {
        long nsamples = 0L;
        this.trimIfNeeded();
        Iterator counterIterator = this.getEventCounters().iterator();
        boolean first = true;
        while (counterIterator.hasNext()) {
            GaugeCounter counter = (GaugeCounter)counterIterator.next();
            nsamples += counter.getSamples();
            if (!first) continue;
            if (this.getWindowStart().isAfter((ReadableInstant)counter.getStart())) {
                nsamples -= (long)(this.getExpiredFraction(counter) * (float)counter.getSamples());
            }
            first = false;
        }
        return nsamples;
    }

    @Override
    public synchronized long getAverage() {
        long nsamples = this.getSamples();
        if (nsamples == 0L) {
            return 0L;
        }
        long value = this.getValue();
        return value / nsamples;
    }

    @Override
    protected GaugeCounter nextCounter(ReadableDateTime start, ReadableDateTime end) {
        return this.gaugeCounterFactory.create(start, end);
    }

    @Override
    public GaugeCounter merge(GaugeCounter counter) {
        if (counter instanceof CompositeGaugeCounter) {
            return this.internalMerge(((CompositeGaugeCounter)counter).getEventCounters(), new CompositeGaugeCounter(this.getMaxLength(), this.getMaxChunkLength(), this.gaugeCounterFactory));
        }
        return this.internalMerge(Arrays.asList(counter), new CompositeGaugeCounter(this.getMaxLength(), this.getMaxChunkLength(), this.gaugeCounterFactory));
    }
}

