/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.EventCounter;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class DecayCounter
implements EventCounter {
    private final AtomicLong count = new AtomicLong(0L);
    private final ReadableDateTime start;
    private final ReadableDateTime decayStart;
    private final ReadableDateTime end;
    private final float decayRatePerSecond;

    public DecayCounter(ReadableDateTime start, ReadableDateTime decayStart, ReadableDateTime end, float decayRatePerSecond) {
        this.start = start;
        this.decayStart = decayStart;
        this.end = end;
        this.decayRatePerSecond = decayRatePerSecond;
    }

    public DecayCounter(ReadableDateTime start, ReadableDateTime end, float decayRatePerSecond) {
        this(start, start, end, decayRatePerSecond);
    }

    @Override
    public void add(long delta) {
        this.count.addAndGet(delta);
    }

    @Override
    public long getValue() {
        DateTime now = this.getNow();
        if (now.isAfter((ReadableInstant)this.decayStart.toDateTime().plusSeconds(1))) {
            Duration elapsed = new Duration((ReadableInstant)this.decayStart, (ReadableInstant)now);
            long millis = elapsed.getMillis();
            double thisDecay = Math.pow(1.0 - (double)this.decayRatePerSecond, (double)millis / 1000.0);
            return (long)((double)this.count.get() * thisDecay);
        }
        return this.count.get();
    }

    @Override
    public ReadableDateTime getStart() {
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        return this.end;
    }

    @Override
    public Duration getLength() {
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public EventCounter merge(EventCounter counter) {
        ReadableDateTime mergedStart = this.start.isBefore((ReadableInstant)counter.getStart()) ? this.start : counter.getStart();
        ReadableDateTime mergedEnd = this.end.isAfter((ReadableInstant)counter.getEnd()) ? this.end : counter.getEnd();
        DateTime now = this.getNow();
        DecayCounter mergedCounter = new DecayCounter(mergedStart, (ReadableDateTime)(now.isAfter((ReadableInstant)this.decayStart) ? now : this.decayStart), mergedEnd, this.decayRatePerSecond);
        mergedCounter.add(this.getValue());
        mergedCounter.add(counter.getValue());
        return mergedCounter;
    }

    DateTime getNow() {
        return new DateTime();
    }
}

