/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.EventCounter;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.EventRate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class EventRateImpl
implements EventRate {
    private final EventCounterIf<EventCounter> counter;
    private final Duration windowSize;
    private final ReadableDateTime start;

    EventRateImpl(EventCounterIf<EventCounter> counter, Duration windowSize, ReadableDateTime start) {
        this.counter = counter;
        this.windowSize = windowSize;
        this.start = start;
    }

    public EventRateImpl(EventCounterIf<EventCounter> counter, Duration windowSize) {
        this(counter, windowSize, (ReadableDateTime)new DateTime());
    }

    @Override
    public void add(long delta) {
        this.counter.add(delta);
    }

    @Override
    public long getValue() {
        Duration periodSize = this.getPeriodSize();
        if (periodSize.getStandardSeconds() == 0L) {
            return 0L;
        }
        return this.counter.getValue() / periodSize.getStandardSeconds();
    }

    private Duration getPeriodSize() {
        DateTime now = new DateTime();
        Duration periodSize = new Duration((ReadableInstant)this.start, (ReadableInstant)now);
        if (periodSize.isLongerThan((ReadableDuration)this.windowSize)) {
            return this.windowSize;
        }
        return periodSize;
    }
}

