/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.google.common.base.Preconditions;

public final class ExponentialDecay {
    private ExponentialDecay() {
    }

    public static double computeAlpha(double targetWeight, int targetAgeInSeconds) {
        Preconditions.checkArgument((targetAgeInSeconds > 0 ? 1 : 0) != 0, (Object)"targetAgeInSeconds must be > 0");
        Preconditions.checkArgument((targetWeight > 0.0 && targetWeight < 1.0 ? 1 : 0) != 0, (Object)"targetWeight must be in range (0, 1)");
        return -Math.log(targetWeight) / (double)targetAgeInSeconds;
    }
}

