/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.DefaultGaugeCounter;
import com.facebook.stats.GaugeCounter;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class FastGaugeCounter
implements GaugeCounter {
    private final ReadableDateTime start;
    private final ReadableDateTime end;
    private final AtomicLong value = new AtomicLong(0L);
    private final AtomicLong nsamples = new AtomicLong(0L);

    public FastGaugeCounter(ReadableDateTime start, ReadableDateTime end) {
        if (start.isAfter((ReadableInstant)end)) {
            this.start = end;
            this.end = start;
        } else {
            this.start = start;
            this.end = end;
        }
    }

    @Override
    public void add(long delta, long samples) {
        this.value.addAndGet(delta);
        this.nsamples.addAndGet(samples);
    }

    @Override
    public void add(long delta) {
        this.add(delta, 1L);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public long getSamples() {
        return this.nsamples.get();
    }

    @Override
    public long getAverage() {
        long samples = this.nsamples.get();
        if (samples == 0L) {
            return 0L;
        }
        return this.value.get() / samples;
    }

    @Override
    public ReadableDateTime getStart() {
        return this.start;
    }

    @Override
    public ReadableDateTime getEnd() {
        return this.end;
    }

    @Override
    public Duration getLength() {
        return new Duration((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    @Override
    public GaugeCounter merge(GaugeCounter counter) {
        ReadableDateTime mergedStart = this.start;
        ReadableDateTime mergedEnd = this.end;
        if (counter.getStart().isBefore((ReadableInstant)mergedStart)) {
            mergedStart = counter.getStart();
        }
        if (counter.getEnd().isAfter((ReadableInstant)mergedEnd)) {
            mergedEnd = counter.getEnd();
        }
        DefaultGaugeCounter mergedCounter = new DefaultGaugeCounter(mergedStart, mergedEnd);
        mergedCounter.add(this.value.get() + counter.getValue(), this.nsamples.get() + counter.getSamples());
        return mergedCounter;
    }
}

