/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.CompositeGaugeCounter;
import com.facebook.stats.DefaultGaugeCounterFactory;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.GaugeCounter;
import com.facebook.stats.GaugeCounterFactory;
import com.facebook.stats.ReadableMultiWindowGauge;
import com.facebook.stats.WritableMultiWindowStat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class MultiWindowGauge
implements ReadableMultiWindowGauge,
WritableMultiWindowStat {
    private final GaugeCounterFactory gaugeCounterFactory;
    private final CompositeGaugeCounter allTimeCounter;
    private final CompositeGaugeCounter hourCounter;
    private final CompositeGaugeCounter tenMinuteCounter;
    private final CompositeGaugeCounter minuteCounter;
    private volatile GaugeCounter currentCounter;
    private final ReadableDateTime start;
    private final Object rollLock = new Object();

    public MultiWindowGauge() {
        this(DefaultGaugeCounterFactory.INSTANCE);
    }

    public MultiWindowGauge(GaugeCounterFactory gaugeCounterFactory) {
        this(gaugeCounterFactory, MultiWindowGauge.newCompositeGaugeCounter(Integer.MAX_VALUE, gaugeCounterFactory), MultiWindowGauge.newCompositeGaugeCounter(60, gaugeCounterFactory), MultiWindowGauge.newCompositeGaugeCounter(10, gaugeCounterFactory), MultiWindowGauge.newCompositeGaugeCounter(1, gaugeCounterFactory), (ReadableDateTime)new DateTime());
    }

    MultiWindowGauge(GaugeCounterFactory gaugeCounterFactory, CompositeGaugeCounter allTimeCounter, CompositeGaugeCounter hourCounter, CompositeGaugeCounter tenMinuteCounter, CompositeGaugeCounter minuteCounter, ReadableDateTime start) {
        this.gaugeCounterFactory = gaugeCounterFactory;
        this.allTimeCounter = allTimeCounter;
        this.hourCounter = hourCounter;
        this.tenMinuteCounter = tenMinuteCounter;
        this.minuteCounter = minuteCounter;
        this.start = start;
        this.currentCounter = this.nextCurrentCounter();
    }

    private static CompositeGaugeCounter newCompositeGaugeCounter(int minutes, GaugeCounterFactory gaugeCounterFactory) {
        return new CompositeGaugeCounter((ReadableDuration)Duration.standardMinutes((long)minutes), gaugeCounterFactory);
    }

    @Override
    public void add(long delta) {
        this.rollCurrentIfNeeded();
        this.currentCounter.add(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentIfNeeded() {
        long now = DateTimeUtils.currentTimeMillis();
        if (this.currentCounter.getEnd().getMillis() < now) {
            Object object = this.rollLock;
            synchronized (object) {
                if (this.currentCounter.getEnd().getMillis() < now) {
                    this.currentCounter = this.nextCurrentCounter();
                }
            }
        }
    }

    private long calcRate(EventCounterIf<GaugeCounter> counter) {
        long value = counter.getValue();
        ReadableDateTime end = counter.getEnd();
        ReadableDateTime start = counter.getStart();
        DateTime now = new DateTime();
        Duration duration = now.isBefore((ReadableInstant)end) ? new Duration((ReadableInstant)start, (ReadableInstant)now) : new Duration((ReadableInstant)start, (ReadableInstant)end);
        long secs = duration.getStandardSeconds();
        return secs > 0L ? value / secs : value;
    }

    @Override
    public long getMinuteSum() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getValue();
    }

    @Override
    public long getMinuteSamples() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getSamples();
    }

    @Override
    public long getMinuteAvg() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getAverage();
    }

    @Override
    public long getMinuteRate() {
        this.rollCurrentIfNeeded();
        return this.calcRate(this.minuteCounter);
    }

    @Override
    public long getTenMinuteSum() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getValue();
    }

    @Override
    public long getTenMinuteSamples() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getSamples();
    }

    @Override
    public long getTenMinuteAvg() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getAverage();
    }

    @Override
    public long getTenMinuteRate() {
        this.rollCurrentIfNeeded();
        return this.calcRate(this.tenMinuteCounter);
    }

    @Override
    public long getHourSum() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getValue();
    }

    @Override
    public long getHourSamples() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getSamples();
    }

    @Override
    public long getHourAvg() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getAverage();
    }

    @Override
    public long getHourRate() {
        this.rollCurrentIfNeeded();
        return this.calcRate(this.hourCounter);
    }

    @Override
    public long getAllTimeSum() {
        return this.allTimeCounter.getValue();
    }

    @Override
    public long getAllTimeSamples() {
        return this.allTimeCounter.getSamples();
    }

    @Override
    public long getAllTimeAvg() {
        return this.allTimeCounter.getAverage();
    }

    @Override
    public long getAllTimeRate() {
        Duration sinceStart = new Duration((ReadableInstant)this.start, (ReadableInstant)new DateTime());
        if (sinceStart.getStandardSeconds() == 0L) {
            return 0L;
        }
        return this.allTimeCounter.getValue() / sinceStart.getStandardSeconds();
    }

    private GaugeCounter nextCurrentCounter() {
        DateTime now = new DateTime();
        GaugeCounter gaugeCounter = this.gaugeCounterFactory.create((ReadableDateTime)now, (ReadableDateTime)now.toDateTime().plusSeconds(6));
        this.allTimeCounter.addEventCounter(gaugeCounter);
        this.hourCounter.addEventCounter(gaugeCounter);
        this.tenMinuteCounter.addEventCounter(gaugeCounter);
        this.minuteCounter.addEventCounter(gaugeCounter);
        return gaugeCounter;
    }

    public MultiWindowGauge merge(MultiWindowGauge rhs) {
        return new MultiWindowGauge(this.gaugeCounterFactory, (CompositeGaugeCounter)this.allTimeCounter.merge(rhs.allTimeCounter), (CompositeGaugeCounter)this.hourCounter.merge(rhs.hourCounter), (CompositeGaugeCounter)this.tenMinuteCounter.merge(rhs.tenMinuteCounter), (CompositeGaugeCounter)this.minuteCounter.merge(rhs.minuteCounter), this.start.isBefore((ReadableInstant)rhs.start) ? this.start : rhs.start);
    }
}

