/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import com.facebook.stats.CompositeSum;
import com.facebook.stats.EventCounter;
import com.facebook.stats.EventCounterIf;
import com.facebook.stats.EventCounterImpl;
import com.facebook.stats.EventRate;
import com.facebook.stats.EventRateImpl;
import com.facebook.stats.ReadableMultiWindowRate;
import com.facebook.stats.WritableMultiWindowStat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class MultiWindowRate
implements ReadableMultiWindowRate,
WritableMultiWindowStat {
    private static final int DEFAULT_TIME_BUCKET_SIZE_MILLIS = 6000;
    private final CompositeSum allTimeCounter;
    private final CompositeSum hourCounter;
    private final CompositeSum tenMinuteCounter;
    private final CompositeSum minuteCounter;
    private final EventRate hourRate;
    private final EventRate tenMinuteRate;
    private final EventRate minuteRate;
    private final ReadableDateTime start;
    private final Object rollLock = new Object();
    private final int timeBucketSizeMillis;
    private volatile EventCounterIf<EventCounter> currentCounter;

    MultiWindowRate(int timeBucketSizeMillis) {
        this(MultiWindowRate.newCompositeEventCounter(Integer.MAX_VALUE), MultiWindowRate.newCompositeEventCounter(60), MultiWindowRate.newCompositeEventCounter(10), MultiWindowRate.newCompositeEventCounter(1), (ReadableDateTime)new DateTime(), timeBucketSizeMillis);
    }

    MultiWindowRate(CompositeSum allTimeCounter, CompositeSum hourCounter, CompositeSum tenMinuteCounter, CompositeSum minuteCounter, ReadableDateTime start, int timeBucketSizeMillis) {
        this.allTimeCounter = allTimeCounter;
        this.hourCounter = hourCounter;
        this.tenMinuteCounter = tenMinuteCounter;
        this.minuteCounter = minuteCounter;
        this.start = start;
        this.timeBucketSizeMillis = timeBucketSizeMillis;
        this.hourRate = this.newEventRate(hourCounter, Duration.standardMinutes((long)60L), start);
        this.tenMinuteRate = this.newEventRate(tenMinuteCounter, Duration.standardMinutes((long)10L), start);
        this.minuteRate = this.newEventRate(minuteCounter, Duration.standardMinutes((long)1L), start);
        this.currentCounter = this.nextCurrentCounter((ReadableDateTime)start.toDateTime());
    }

    public MultiWindowRate() {
        this(6000);
    }

    private static CompositeSum newCompositeEventCounter(int minutes) {
        return new CompositeSum((ReadableDuration)Duration.standardMinutes((long)minutes));
    }

    private EventRate newEventRate(EventCounterIf<EventCounter> counter, Duration windowSize, ReadableDateTime start) {
        return new EventRateImpl(counter, windowSize, start);
    }

    @Override
    public void add(long delta) {
        this.rollCurrentIfNeeded();
        this.currentCounter.add(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentIfNeeded() {
        long now = DateTimeUtils.currentTimeMillis();
        if (this.currentCounter.getEnd().getMillis() <= now) {
            Object object = this.rollLock;
            synchronized (object) {
                if (this.currentCounter.getEnd().getMillis() <= now) {
                    this.currentCounter = this.nextCurrentCounter((ReadableDateTime)new DateTime(now));
                }
            }
        }
    }

    @Override
    public long getMinuteSum() {
        this.rollCurrentIfNeeded();
        return this.minuteCounter.getValue();
    }

    @Override
    public long getMinuteRate() {
        this.rollCurrentIfNeeded();
        return this.minuteRate.getValue();
    }

    @Override
    public long getTenMinuteSum() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteCounter.getValue();
    }

    @Override
    public long getTenMinuteRate() {
        this.rollCurrentIfNeeded();
        return this.tenMinuteRate.getValue();
    }

    @Override
    public long getHourSum() {
        this.rollCurrentIfNeeded();
        return this.hourCounter.getValue();
    }

    @Override
    public long getHourRate() {
        this.rollCurrentIfNeeded();
        return this.hourRate.getValue();
    }

    @Override
    public long getAllTimeSum() {
        return this.allTimeCounter.getValue();
    }

    @Override
    public long getAllTimeRate() {
        Duration sinceStart = new Duration((ReadableInstant)this.start, (ReadableInstant)this.getNow());
        if (sinceStart.getStandardSeconds() == 0L) {
            return 0L;
        }
        return this.allTimeCounter.getValue() / sinceStart.getStandardSeconds();
    }

    protected ReadableDateTime getNow() {
        return new DateTime();
    }

    private EventCounterIf<EventCounter> nextCurrentCounter(ReadableDateTime now) {
        EventCounterImpl eventCounter = new EventCounterImpl(now, (ReadableDateTime)now.toDateTime().plusMillis(this.timeBucketSizeMillis));
        this.allTimeCounter.addEventCounter(eventCounter);
        this.hourCounter.addEventCounter(eventCounter);
        this.tenMinuteCounter.addEventCounter(eventCounter);
        this.minuteCounter.addEventCounter(eventCounter);
        return eventCounter;
    }

    public MultiWindowRate merge(MultiWindowRate rate) {
        return new MultiWindowRate((CompositeSum)this.allTimeCounter.merge(rate.allTimeCounter), (CompositeSum)this.hourCounter.merge(rate.hourCounter), (CompositeSum)this.tenMinuteCounter.merge(rate.tenMinuteCounter), (CompositeSum)this.minuteCounter.merge(rate.minuteCounter), this.start.isBefore((ReadableInstant)rate.start) ? this.start : rate.start, this.timeBucketSizeMillis);
    }
}

