/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTimeUtils;

public class ShardedConcurrentCounter {
    private static int MEMORY_WORD_MULTIPLIER = 1;
    private volatile long value = 0L;
    private final long maxStaleMillis;
    private volatile long globalLastDrainMillis = DateTimeUtils.currentTimeMillis();
    private final CounterShard[] counterShards;

    public ShardedConcurrentCounter(int numShards, long maxStaleMillis) {
        this.maxStaleMillis = maxStaleMillis;
        this.counterShards = new CounterShard[MEMORY_WORD_MULTIPLIER * numShards];
        long now = DateTimeUtils.currentTimeMillis();
        long staggerMillis = maxStaleMillis / (long)numShards;
        for (int i = 0; i < MEMORY_WORD_MULTIPLIER * numShards; ++i) {
            long firstDrainMillis = now + (long)i * staggerMillis;
            this.counterShards[i] = new CounterShard(firstDrainMillis, (long)(1.5 * (double)maxStaleMillis));
        }
    }

    public ShardedConcurrentCounter() {
        this(16, 500L);
    }

    public void add(long delta) {
        this.counterShards[this.getShard()].add(delta);
    }

    private int getShard() {
        return MEMORY_WORD_MULTIPLIER * (int)Thread.currentThread().getId() % this.counterShards.length;
    }

    public long get() {
        this.drainThreadToShared();
        return this.value;
    }

    public long getStale() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIfStale() {
        if (DateTimeUtils.currentTimeMillis() - this.globalLastDrainMillis < this.maxStaleMillis) return;
        CounterShard[] counterShardArray = this.counterShards;
        synchronized (this.counterShards) {
            if (DateTimeUtils.currentTimeMillis() - this.globalLastDrainMillis < this.maxStaleMillis) return;
            this.drainThreadToShared();
            this.globalLastDrainMillis = DateTimeUtils.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainThreadToShared() {
        CounterShard[] counterShardArray = this.counterShards;
        synchronized (this.counterShards) {
            for (CounterShard counterShard : this.counterShards) {
                this.value += counterShard.drain();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class CounterShard {
        private final long frequencyMillis;
        private final AtomicLong counter = new AtomicLong(0L);
        private volatile long lastDrainMillis;

        private CounterShard(long firstDrainMillis, long frequencyMillis) {
            this.lastDrainMillis = firstDrainMillis;
            this.frequencyMillis = frequencyMillis;
        }

        private void add(long delta) {
            if (DateTimeUtils.currentTimeMillis() - this.lastDrainMillis >= this.frequencyMillis) {
                ShardedConcurrentCounter.this.drainThreadToShared();
                this.lastDrainMillis = DateTimeUtils.currentTimeMillis();
            }
            this.counter.addAndGet(delta);
        }

        private long drain() {
            return this.counter.getAndSet(0L);
        }
    }
}

